/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v2_3;

import io.fabric8.kubernetes.api.builder.v2_3.BaseFluent;
import io.fabric8.kubernetes.api.builder.v2_3.Nested;
import io.fabric8.kubernetes.api.builder.v2_3.Predicate;
import io.fabric8.kubernetes.api.model.v2_3.ObjectMeta;
import io.fabric8.kubernetes.api.model.v2_3.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v2_3.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.v2_3.NamedRole;
import io.fabric8.openshift.api.model.v2_3.NamedRoleBuilder;
import io.fabric8.openshift.api.model.v2_3.NamedRoleFluentImpl;
import io.fabric8.openshift.api.model.v2_3.Policy;
import io.fabric8.openshift.api.model.v2_3.PolicyFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PolicyFluentImpl<A extends PolicyFluent<A>>
extends BaseFluent<A>
implements PolicyFluent<A> {
    private String apiVersion;
    private String kind;
    private String lastModified;
    private ObjectMetaBuilder metadata;
    private List<NamedRoleBuilder> roles = new ArrayList<NamedRoleBuilder>();

    public PolicyFluentImpl() {
    }

    public PolicyFluentImpl(Policy instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withLastModified(instance.getLastModified());
        this.withMetadata(instance.getMetadata());
        this.withRoles(instance.getRoles());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public String getLastModified() {
        return this.lastModified;
    }

    @Override
    public A withLastModified(String lastModified) {
        this.lastModified = lastModified;
        return (A)this;
    }

    @Override
    public Boolean hasLastModified() {
        return this.lastModified != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public PolicyFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public PolicyFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public PolicyFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public PolicyFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public PolicyFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToRoles(int index, NamedRole item) {
        NamedRoleBuilder builder = new NamedRoleBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.roles.add(index >= 0 ? index : this.roles.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRoles(int index, NamedRole item) {
        NamedRoleBuilder builder = new NamedRoleBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.roles.size()) {
            this.roles.add(builder);
        } else {
            this.roles.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRoles(NamedRole ... items) {
        for (NamedRole item : items) {
            NamedRoleBuilder builder = new NamedRoleBuilder(item);
            this._visitables.add(builder);
            this.roles.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRoles(Collection<NamedRole> items) {
        for (NamedRole item : items) {
            NamedRoleBuilder builder = new NamedRoleBuilder(item);
            this._visitables.add(builder);
            this.roles.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRoles(NamedRole ... items) {
        for (NamedRole item : items) {
            NamedRoleBuilder builder = new NamedRoleBuilder(item);
            this._visitables.remove(builder);
            this.roles.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRoles(Collection<NamedRole> items) {
        for (NamedRole item : items) {
            NamedRoleBuilder builder = new NamedRoleBuilder(item);
            this._visitables.remove(builder);
            this.roles.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NamedRole> getRoles() {
        return PolicyFluentImpl.build(this.roles);
    }

    @Override
    public List<NamedRole> buildRoles() {
        return PolicyFluentImpl.build(this.roles);
    }

    @Override
    public NamedRole buildRole(int index) {
        return this.roles.get(index).build();
    }

    @Override
    public NamedRole buildFirstRole() {
        return this.roles.get(0).build();
    }

    @Override
    public NamedRole buildLastRole() {
        return this.roles.get(this.roles.size() - 1).build();
    }

    @Override
    public NamedRole buildMatchingRole(Predicate<NamedRoleBuilder> predicate) {
        for (NamedRoleBuilder item : this.roles) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withRoles(List<NamedRole> roles) {
        this._visitables.removeAll(this.roles);
        this.roles.clear();
        if (roles != null) {
            for (NamedRole item : roles) {
                this.addToRoles(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withRoles(NamedRole ... roles) {
        this.roles.clear();
        if (roles != null) {
            for (NamedRole item : roles) {
                this.addToRoles(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRoles() {
        return this.roles != null && !this.roles.isEmpty();
    }

    @Override
    public PolicyFluent.RolesNested<A> addNewRole() {
        return new RolesNestedImpl();
    }

    @Override
    public PolicyFluent.RolesNested<A> addNewRoleLike(NamedRole item) {
        return new RolesNestedImpl(-1, item);
    }

    @Override
    public PolicyFluent.RolesNested<A> setNewRoleLike(int index, NamedRole item) {
        return new RolesNestedImpl(index, item);
    }

    @Override
    public PolicyFluent.RolesNested<A> editRole(int index) {
        if (this.roles.size() <= index) {
            throw new RuntimeException("Can't edit roles. Index exceeds size.");
        }
        return this.setNewRoleLike(index, this.buildRole(index));
    }

    @Override
    public PolicyFluent.RolesNested<A> editFirstRole() {
        if (this.roles.size() == 0) {
            throw new RuntimeException("Can't edit first roles. The list is empty.");
        }
        return this.setNewRoleLike(0, this.buildRole(0));
    }

    @Override
    public PolicyFluent.RolesNested<A> editLastRole() {
        int index = this.roles.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last roles. The list is empty.");
        }
        return this.setNewRoleLike(index, this.buildRole(index));
    }

    @Override
    public PolicyFluent.RolesNested<A> editMatchingRole(Predicate<NamedRoleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.roles.size(); ++i) {
            if (!predicate.apply(this.roles.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching roles. No match found.");
        }
        return this.setNewRoleLike(index, this.buildRole(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PolicyFluentImpl that = (PolicyFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.lastModified != null ? !this.lastModified.equals(that.lastModified) : that.lastModified != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.roles != null ? !this.roles.equals(that.roles) : that.roles != null);
    }

    public class RolesNestedImpl<N>
    extends NamedRoleFluentImpl<PolicyFluent.RolesNested<N>>
    implements PolicyFluent.RolesNested<N>,
    Nested<N> {
        private final NamedRoleBuilder builder;
        private final int index;

        RolesNestedImpl(int index, NamedRole item) {
            this.index = index;
            this.builder = new NamedRoleBuilder(this, item);
        }

        RolesNestedImpl() {
            this.index = -1;
            this.builder = new NamedRoleBuilder(this);
        }

        @Override
        public N and() {
            return (N)PolicyFluentImpl.this.setToRoles(this.index, this.builder.build());
        }

        @Override
        public N endRole() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<PolicyFluent.MetadataNested<N>>
    implements PolicyFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)PolicyFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

