/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v2_3;

import io.fabric8.kubernetes.api.builder.v2_3.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v2_3.VisitableBuilder;
import io.fabric8.openshift.api.model.v2_3.ImageStreamStatus;
import io.fabric8.openshift.api.model.v2_3.ImageStreamStatusFluent;
import io.fabric8.openshift.api.model.v2_3.ImageStreamStatusFluentImpl;

public class ImageStreamStatusBuilder
extends ImageStreamStatusFluentImpl<ImageStreamStatusBuilder>
implements VisitableBuilder<ImageStreamStatus, ImageStreamStatusBuilder> {
    ImageStreamStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ImageStreamStatusBuilder() {
        this(true);
    }

    public ImageStreamStatusBuilder(Boolean validationEnabled) {
        this(new ImageStreamStatus(), validationEnabled);
    }

    public ImageStreamStatusBuilder(ImageStreamStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ImageStreamStatusBuilder(ImageStreamStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ImageStreamStatus(), validationEnabled);
    }

    public ImageStreamStatusBuilder(ImageStreamStatusFluent<?> fluent, ImageStreamStatus instance) {
        this(fluent, instance, true);
    }

    public ImageStreamStatusBuilder(ImageStreamStatusFluent<?> fluent, ImageStreamStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDockerImageRepository(instance.getDockerImageRepository());
        fluent.withTags(instance.getTags());
        this.validationEnabled = validationEnabled;
    }

    public ImageStreamStatusBuilder(ImageStreamStatus instance) {
        this(instance, (Boolean)true);
    }

    public ImageStreamStatusBuilder(ImageStreamStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDockerImageRepository(instance.getDockerImageRepository());
        this.withTags(instance.getTags());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ImageStreamStatus build() {
        ImageStreamStatus buildable = new ImageStreamStatus(this.fluent.getDockerImageRepository(), this.fluent.getTags());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageStreamStatusBuilder that = (ImageStreamStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

