/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v2_3;

import io.fabric8.kubernetes.api.builder.v2_3.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v2_3.VisitableBuilder;
import io.fabric8.openshift.api.model.v2_3.Image;
import io.fabric8.openshift.api.model.v2_3.ImageFluent;
import io.fabric8.openshift.api.model.v2_3.ImageFluentImpl;

public class ImageBuilder
extends ImageFluentImpl<ImageBuilder>
implements VisitableBuilder<Image, ImageBuilder> {
    ImageFluent<?> fluent;
    Boolean validationEnabled;

    public ImageBuilder() {
        this(true);
    }

    public ImageBuilder(Boolean validationEnabled) {
        this(new Image(), validationEnabled);
    }

    public ImageBuilder(ImageFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ImageBuilder(ImageFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Image(), validationEnabled);
    }

    public ImageBuilder(ImageFluent<?> fluent, Image instance) {
        this(fluent, instance, true);
    }

    public ImageBuilder(ImageFluent<?> fluent, Image instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withDockerImageConfig(instance.getDockerImageConfig());
        fluent.withDockerImageLayers(instance.getDockerImageLayers());
        fluent.withDockerImageManifest(instance.getDockerImageManifest());
        fluent.withDockerImageManifestMediaType(instance.getDockerImageManifestMediaType());
        fluent.withDockerImageMetadataVersion(instance.getDockerImageMetadataVersion());
        fluent.withDockerImageReference(instance.getDockerImageReference());
        fluent.withDockerImageSignatures(instance.getDockerImageSignatures());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSignatures(instance.getSignatures());
        this.validationEnabled = validationEnabled;
    }

    public ImageBuilder(Image instance) {
        this(instance, (Boolean)true);
    }

    public ImageBuilder(Image instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withDockerImageConfig(instance.getDockerImageConfig());
        this.withDockerImageLayers(instance.getDockerImageLayers());
        this.withDockerImageManifest(instance.getDockerImageManifest());
        this.withDockerImageManifestMediaType(instance.getDockerImageManifestMediaType());
        this.withDockerImageMetadataVersion(instance.getDockerImageMetadataVersion());
        this.withDockerImageReference(instance.getDockerImageReference());
        this.withDockerImageSignatures(instance.getDockerImageSignatures());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSignatures(instance.getSignatures());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Image build() {
        Image buildable = new Image(this.fluent.getApiVersion(), this.fluent.getDockerImageConfig(), this.fluent.getDockerImageLayers(), this.fluent.getDockerImageManifest(), this.fluent.getDockerImageManifestMediaType(), this.fluent.getDockerImageMetadataVersion(), this.fluent.getDockerImageReference(), this.fluent.getDockerImageSignatures(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSignatures());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageBuilder that = (ImageBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

