/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v2_3;

import io.fabric8.kubernetes.api.builder.v2_3.BaseFluent;
import io.fabric8.kubernetes.api.builder.v2_3.Nested;
import io.fabric8.kubernetes.api.builder.v2_3.Predicate;
import io.fabric8.kubernetes.api.model.v2_3.EnvVar;
import io.fabric8.kubernetes.api.model.v2_3.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.v2_3.EnvVarFluentImpl;
import io.fabric8.openshift.api.model.v2_3.ExecNewPodHook;
import io.fabric8.openshift.api.model.v2_3.ExecNewPodHookFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExecNewPodHookFluentImpl<A extends ExecNewPodHookFluent<A>>
extends BaseFluent<A>
implements ExecNewPodHookFluent<A> {
    private List<String> command = new ArrayList<String>();
    private String containerName;
    private List<EnvVarBuilder> env = new ArrayList<EnvVarBuilder>();
    private List<String> volumes = new ArrayList<String>();

    public ExecNewPodHookFluentImpl() {
    }

    public ExecNewPodHookFluentImpl(ExecNewPodHook instance) {
        this.withCommand(instance.getCommand());
        this.withContainerName(instance.getContainerName());
        this.withEnv(instance.getEnv());
        this.withVolumes(instance.getVolumes());
    }

    @Override
    public A addToCommand(int index, String item) {
        this.command.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCommand(int index, String item) {
        this.command.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCommand(String ... items) {
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCommand(Collection<String> items) {
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCommand(String ... items) {
        for (String item : items) {
            this.command.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCommand(Collection<String> items) {
        for (String item : items) {
            this.command.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCommand() {
        return this.command;
    }

    @Override
    public String getCommand(int index) {
        return this.command.get(index);
    }

    @Override
    public String getFirstCommand() {
        return this.command.get(0);
    }

    @Override
    public String getLastCommand() {
        return this.command.get(this.command.size() - 1);
    }

    @Override
    public String getMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withCommand(List<String> command) {
        this.command.clear();
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withCommand(String ... command) {
        this.command.clear();
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCommand() {
        return this.command != null && !this.command.isEmpty();
    }

    @Override
    public String getContainerName() {
        return this.containerName;
    }

    @Override
    public A withContainerName(String containerName) {
        this.containerName = containerName;
        return (A)this;
    }

    @Override
    public Boolean hasContainerName() {
        return this.containerName != null;
    }

    @Override
    public A addToEnv(int index, EnvVar item) {
        EnvVarBuilder builder = new EnvVarBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.env.add(index >= 0 ? index : this.env.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEnv(int index, EnvVar item) {
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.env.size()) {
            this.env.add(builder);
        } else {
            this.env.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnv(Collection<EnvVar> items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.remove(builder);
            this.env.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnv(Collection<EnvVar> items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.remove(builder);
            this.env.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<EnvVar> getEnv() {
        return ExecNewPodHookFluentImpl.build(this.env);
    }

    @Override
    public List<EnvVar> buildEnv() {
        return ExecNewPodHookFluentImpl.build(this.env);
    }

    @Override
    public EnvVar buildEnv(int index) {
        return this.env.get(index).build();
    }

    @Override
    public EnvVar buildFirstEnv() {
        return this.env.get(0).build();
    }

    @Override
    public EnvVar buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    @Override
    public EnvVar buildMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.env) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withEnv(List<EnvVar> env) {
        this._visitables.removeAll(this.env);
        this.env.clear();
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withEnv(EnvVar ... env) {
        this.env.clear();
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    @Override
    public ExecNewPodHookFluent.EnvNested<A> addNewEnv() {
        return new EnvNestedImpl();
    }

    @Override
    public ExecNewPodHookFluent.EnvNested<A> addNewEnvLike(EnvVar item) {
        return new EnvNestedImpl(-1, item);
    }

    @Override
    public ExecNewPodHookFluent.EnvNested<A> setNewEnvLike(int index, EnvVar item) {
        return new EnvNestedImpl(index, item);
    }

    @Override
    public ExecNewPodHookFluent.EnvNested<A> editEnv(int index) {
        if (this.env.size() <= index) {
            throw new RuntimeException("Can't edit env. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public ExecNewPodHookFluent.EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException("Can't edit first env. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    @Override
    public ExecNewPodHookFluent.EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last env. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public ExecNewPodHookFluent.EnvNested<A> editMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.apply(this.env.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching env. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public A addToVolumes(int index, String item) {
        this.volumes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVolumes(int index, String item) {
        this.volumes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVolumes(String ... items) {
        for (String item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<String> items) {
        for (String item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(String ... items) {
        for (String item : items) {
            this.volumes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<String> items) {
        for (String item : items) {
            this.volumes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getVolumes() {
        return this.volumes;
    }

    @Override
    public String getVolume(int index) {
        return this.volumes.get(index);
    }

    @Override
    public String getFirstVolume() {
        return this.volumes.get(0);
    }

    @Override
    public String getLastVolume() {
        return this.volumes.get(this.volumes.size() - 1);
    }

    @Override
    public String getMatchingVolume(Predicate<String> predicate) {
        for (String item : this.volumes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withVolumes(List<String> volumes) {
        this.volumes.clear();
        if (volumes != null) {
            for (String item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withVolumes(String ... volumes) {
        this.volumes.clear();
        if (volumes != null) {
            for (String item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExecNewPodHookFluentImpl that = (ExecNewPodHookFluentImpl)o;
        if (this.command != null ? !this.command.equals(that.command) : that.command != null) {
            return false;
        }
        if (this.containerName != null ? !this.containerName.equals(that.containerName) : that.containerName != null) {
            return false;
        }
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        return !(this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null);
    }

    public class EnvNestedImpl<N>
    extends EnvVarFluentImpl<ExecNewPodHookFluent.EnvNested<N>>
    implements ExecNewPodHookFluent.EnvNested<N>,
    Nested<N> {
        private final EnvVarBuilder builder;
        private final int index;

        EnvNestedImpl(int index, EnvVar item) {
            this.index = index;
            this.builder = new EnvVarBuilder(this, item);
        }

        EnvNestedImpl() {
            this.index = -1;
            this.builder = new EnvVarBuilder(this);
        }

        @Override
        public N and() {
            return (N)ExecNewPodHookFluentImpl.this.setToEnv(this.index, this.builder.build());
        }

        @Override
        public N endEnv() {
            return this.and();
        }
    }
}

