/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v2_3;

import io.fabric8.kubernetes.api.builder.v2_3.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v2_3.VisitableBuilder;
import io.fabric8.openshift.api.model.v2_3.CustomBuildStrategy;
import io.fabric8.openshift.api.model.v2_3.CustomBuildStrategyFluent;
import io.fabric8.openshift.api.model.v2_3.CustomBuildStrategyFluentImpl;

public class CustomBuildStrategyBuilder
extends CustomBuildStrategyFluentImpl<CustomBuildStrategyBuilder>
implements VisitableBuilder<CustomBuildStrategy, CustomBuildStrategyBuilder> {
    CustomBuildStrategyFluent<?> fluent;
    Boolean validationEnabled;

    public CustomBuildStrategyBuilder() {
        this(true);
    }

    public CustomBuildStrategyBuilder(Boolean validationEnabled) {
        this(new CustomBuildStrategy(), validationEnabled);
    }

    public CustomBuildStrategyBuilder(CustomBuildStrategyFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CustomBuildStrategyBuilder(CustomBuildStrategyFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CustomBuildStrategy(), validationEnabled);
    }

    public CustomBuildStrategyBuilder(CustomBuildStrategyFluent<?> fluent, CustomBuildStrategy instance) {
        this(fluent, instance, true);
    }

    public CustomBuildStrategyBuilder(CustomBuildStrategyFluent<?> fluent, CustomBuildStrategy instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withBuildAPIVersion(instance.getBuildAPIVersion());
        fluent.withEnv(instance.getEnv());
        fluent.withExposeDockerSocket(instance.getExposeDockerSocket());
        fluent.withForcePull(instance.getForcePull());
        fluent.withFrom(instance.getFrom());
        fluent.withPullSecret(instance.getPullSecret());
        fluent.withSecrets(instance.getSecrets());
        this.validationEnabled = validationEnabled;
    }

    public CustomBuildStrategyBuilder(CustomBuildStrategy instance) {
        this(instance, (Boolean)true);
    }

    public CustomBuildStrategyBuilder(CustomBuildStrategy instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withBuildAPIVersion(instance.getBuildAPIVersion());
        this.withEnv(instance.getEnv());
        this.withExposeDockerSocket(instance.getExposeDockerSocket());
        this.withForcePull(instance.getForcePull());
        this.withFrom(instance.getFrom());
        this.withPullSecret(instance.getPullSecret());
        this.withSecrets(instance.getSecrets());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public CustomBuildStrategy build() {
        CustomBuildStrategy buildable = new CustomBuildStrategy(this.fluent.getBuildAPIVersion(), this.fluent.getEnv(), this.fluent.isExposeDockerSocket(), this.fluent.isForcePull(), this.fluent.getFrom(), this.fluent.getPullSecret(), this.fluent.getSecrets());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomBuildStrategyBuilder that = (CustomBuildStrategyBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

