/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v2_3.dsl.internal;

import io.fabric8.kubernetes.api.model.v2_3.Container;
import io.fabric8.kubernetes.api.model.v2_3.ContainerBuilder;
import io.fabric8.kubernetes.api.model.v2_3.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.v2_3.extensions.DoneableStatefulSet;
import io.fabric8.kubernetes.api.model.v2_3.extensions.StatefulSet;
import io.fabric8.kubernetes.api.model.v2_3.extensions.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.v2_3.extensions.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.v2_3.extensions.StatefulSetList;
import io.fabric8.kubernetes.api.model.v2_3.extensions.StatefulSetSpecFluent;
import io.fabric8.kubernetes.clnt.v2_3.Config;
import io.fabric8.kubernetes.clnt.v2_3.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v2_3.Watch;
import io.fabric8.kubernetes.clnt.v2_3.Watcher;
import io.fabric8.kubernetes.clnt.v2_3.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.clnt.v2_3.dsl.ImageEditReplacePatchable;
import io.fabric8.kubernetes.clnt.v2_3.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v2_3.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.clnt.v2_3.dsl.Watchable;
import io.fabric8.kubernetes.clnt.v2_3.dsl.internal.RollableScalableResourceOperation;
import io.fabric8.kubernetes.clnt.v2_3.dsl.internal.RollingUpdater;
import io.fabric8.kubernetes.clnt.v2_3.dsl.internal.StatefulSetRollingUpdater;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class StatefulSetOperationsImpl
extends RollableScalableResourceOperation<StatefulSet, StatefulSetList, DoneableStatefulSet, RollableScalableResource<StatefulSet, DoneableStatefulSet>>
implements TimeoutImageEditReplacePatchable<StatefulSet, StatefulSet, DoneableStatefulSet> {
    public StatefulSetOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(client, config, "v1beta1", namespace, null, true, null, null, false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), false, config.getRollingTimeout(), TimeUnit.MILLISECONDS);
    }

    public StatefulSetOperationsImpl(OkHttpClient client, Config config, String apiVersion, String namespace, String name, Boolean cascading, StatefulSet item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        this(client, config, apiVersion, namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields, false, config.getRollingTimeout(), TimeUnit.MILLISECONDS);
    }

    public StatefulSetOperationsImpl(OkHttpClient client, Config config, String apiVersion, String namespace, String name, Boolean cascading, StatefulSet item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields, Boolean rolling, long rollingTimeout, TimeUnit rollingTimeUnit) {
        super(client, config, "apps", apiVersion, "statefulsets", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields, rolling, rollingTimeout, rollingTimeUnit);
    }

    @Override
    public ImageEditReplacePatchable<StatefulSet, StatefulSet, DoneableStatefulSet> withTimeout(long timeout, TimeUnit unit) {
        return new StatefulSetOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.namespace, this.getName(), this.isCascading(), (StatefulSet)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, timeout, unit);
    }

    @Override
    public ImageEditReplacePatchable<StatefulSet, StatefulSet, DoneableStatefulSet> withTimeoutInMillis(long timeoutInMillis) {
        return new StatefulSetOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.namespace, this.getName(), this.isCascading(), (StatefulSet)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    StatefulSet withReplicas(int count) {
        return ((DoneableStatefulSet)((StatefulSetFluent.SpecNested)((DoneableStatefulSet)this.cascading(false).edit()).editSpec().withReplicas(count)).endSpec()).done();
    }

    @Override
    RollingUpdater<StatefulSet, StatefulSetList, DoneableStatefulSet> getRollingUpdater(long rollingTimeout, TimeUnit rollingTimeUnit) {
        return new StatefulSetRollingUpdater(this.client, this.config, this.getNamespace(), rollingTimeUnit.toMillis(rollingTimeout), this.config.getLoggingInterval());
    }

    @Override
    int getCurrentReplicas(StatefulSet current) {
        return current.getStatus().getReplicas();
    }

    @Override
    int getDesiredReplicas(StatefulSet item) {
        return item.getSpec().getReplicas();
    }

    @Override
    long getObservedGeneration(StatefulSet current) {
        return current != null && current.getStatus() != null && current.getStatus().getObservedGeneration() != null ? current.getStatus().getObservedGeneration() : -1L;
    }

    @Override
    public RollableScalableResource<StatefulSet, DoneableStatefulSet> withName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name must be provided.");
        }
        return new StatefulSetOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), name, this.isCascading(), (StatefulSet)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    @Override
    public RollableScalableResource<StatefulSet, DoneableStatefulSet> fromServer() {
        return new StatefulSetOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (StatefulSet)this.getItem(), this.getResourceVersion(), true, this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    @Override
    public Watchable<Watch, Watcher<StatefulSet>> withResourceVersion(String resourceVersion) {
        return new StatefulSetOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (StatefulSet)this.getItem(), resourceVersion, this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    @Override
    public EditReplacePatchDeletable<StatefulSet, StatefulSet, DoneableStatefulSet, Boolean> cascading(boolean enabled) {
        return new StatefulSetOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), enabled, (StatefulSet)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    @Override
    public StatefulSetOperationsImpl rolling() {
        return new StatefulSetOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (StatefulSet)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), true, this.rollingTimeout, this.rollingTimeUnit);
    }

    @Override
    public StatefulSet updateImage(String image) {
        StatefulSet oldRC = (StatefulSet)this.get();
        if (oldRC == null) {
            throw new KubernetesClientException("Existing StatefulSet doesn't exist");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() > 1) {
            throw new KubernetesClientException("Image update is not supported for multicontainer pods");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() == 0) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        Container updatedContainer = ((ContainerBuilder)new ContainerBuilder(oldRC.getSpec().getTemplate().getSpec().getContainers().iterator().next()).withImage(image)).build();
        StatefulSetBuilder newRCBuilder = new StatefulSetBuilder(oldRC);
        ((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((StatefulSetBuilder)((StatefulSetFluent.MetadataNested)newRCBuilder.editMetadata().withResourceVersion(null)).endMetadata()).editSpec().editTemplate().editSpec().withContainers(Collections.singletonList(updatedContainer))).endSpec()).endTemplate()).endSpec();
        return new StatefulSetRollingUpdater(this.client, this.config, this.namespace).rollUpdate(oldRC, newRCBuilder.build());
    }
}

