/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_3.extensions;

import io.fabric8.kubernetes.api.builder.v2_3.BaseFluent;
import io.fabric8.kubernetes.api.builder.v2_3.Nested;
import io.fabric8.kubernetes.api.model.v2_3.ObjectMeta;
import io.fabric8.kubernetes.api.model.v2_3.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v2_3.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.v2_3.extensions.StatefulSet;
import io.fabric8.kubernetes.api.model.v2_3.extensions.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.v2_3.extensions.StatefulSetSpec;
import io.fabric8.kubernetes.api.model.v2_3.extensions.StatefulSetSpecBuilder;
import io.fabric8.kubernetes.api.model.v2_3.extensions.StatefulSetSpecFluentImpl;
import io.fabric8.kubernetes.api.model.v2_3.extensions.StatefulSetStatus;
import io.fabric8.kubernetes.api.model.v2_3.extensions.StatefulSetStatusBuilder;
import io.fabric8.kubernetes.api.model.v2_3.extensions.StatefulSetStatusFluentImpl;

public class StatefulSetFluentImpl<A extends StatefulSetFluent<A>>
extends BaseFluent<A>
implements StatefulSetFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private StatefulSetSpecBuilder spec;
    private StatefulSetStatusBuilder status;

    public StatefulSetFluentImpl() {
    }

    public StatefulSetFluentImpl(StatefulSet instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public StatefulSetFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public StatefulSetFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public StatefulSetFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public StatefulSetFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public StatefulSetFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public StatefulSetSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public StatefulSetSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(StatefulSetSpec spec) {
        this._visitables.remove(this.spec);
        if (spec != null) {
            this.spec = new StatefulSetSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public StatefulSetFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public StatefulSetFluent.SpecNested<A> withNewSpecLike(StatefulSetSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public StatefulSetFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public StatefulSetFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new StatefulSetSpecBuilder().build());
    }

    @Override
    public StatefulSetFluent.SpecNested<A> editOrNewSpecLike(StatefulSetSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public StatefulSetStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public StatefulSetStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(StatefulSetStatus status) {
        this._visitables.remove(this.status);
        if (status != null) {
            this.status = new StatefulSetStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public StatefulSetFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public StatefulSetFluent.StatusNested<A> withNewStatusLike(StatefulSetStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public StatefulSetFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public StatefulSetFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new StatefulSetStatusBuilder().build());
    }

    @Override
    public StatefulSetFluent.StatusNested<A> editOrNewStatusLike(StatefulSetStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    @Override
    public A withNewStatus(Long observedGeneration, Integer replicas) {
        return this.withStatus(new StatefulSetStatus(observedGeneration, replicas));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatefulSetFluentImpl that = (StatefulSetFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends StatefulSetStatusFluentImpl<StatefulSetFluent.StatusNested<N>>
    implements StatefulSetFluent.StatusNested<N>,
    Nested<N> {
        private final StatefulSetStatusBuilder builder;

        StatusNestedImpl(StatefulSetStatus item) {
            this.builder = new StatefulSetStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new StatefulSetStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)StatefulSetFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends StatefulSetSpecFluentImpl<StatefulSetFluent.SpecNested<N>>
    implements StatefulSetFluent.SpecNested<N>,
    Nested<N> {
        private final StatefulSetSpecBuilder builder;

        SpecNestedImpl(StatefulSetSpec item) {
            this.builder = new StatefulSetSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new StatefulSetSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)StatefulSetFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<StatefulSetFluent.MetadataNested<N>>
    implements StatefulSetFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)StatefulSetFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

