/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_3.extensions;

import io.fabric8.kubernetes.api.builder.v2_3.BaseFluent;
import io.fabric8.kubernetes.api.model.v2_3.extensions.ScaleStatus;
import io.fabric8.kubernetes.api.model.v2_3.extensions.ScaleStatusFluent;
import java.util.LinkedHashMap;
import java.util.Map;

public class ScaleStatusFluentImpl<A extends ScaleStatusFluent<A>>
extends BaseFluent<A>
implements ScaleStatusFluent<A> {
    private Integer replicas;
    private Map<String, String> selector = new LinkedHashMap<String, String>();
    private String targetSelector;

    public ScaleStatusFluentImpl() {
    }

    public ScaleStatusFluentImpl(ScaleStatus instance) {
        this.withReplicas(instance.getReplicas());
        this.withSelector(instance.getSelector());
        this.withTargetSelector(instance.getTargetSelector());
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    public A addToSelector(String key, String value) {
        if (key != null && value != null) {
            this.selector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToSelector(Map<String, String> map) {
        if (map != null) {
            this.selector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromSelector(String key) {
        if (key != null) {
            this.selector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromSelector(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.selector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getSelector() {
        return this.selector;
    }

    @Override
    public A withSelector(Map<String, String> selector) {
        this.selector.clear();
        if (selector != null) {
            this.selector.putAll(selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public String getTargetSelector() {
        return this.targetSelector;
    }

    @Override
    public A withTargetSelector(String targetSelector) {
        this.targetSelector = targetSelector;
        return (A)this;
    }

    @Override
    public Boolean hasTargetSelector() {
        return this.targetSelector != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScaleStatusFluentImpl that = (ScaleStatusFluentImpl)o;
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        return !(this.targetSelector != null ? !this.targetSelector.equals(that.targetSelector) : that.targetSelector != null);
    }
}

