/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_3.extensions;

import io.fabric8.kubernetes.api.builder.v2_3.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v2_3.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v2_3.extensions.ScaleSpec;
import io.fabric8.kubernetes.api.model.v2_3.extensions.ScaleSpecFluent;
import io.fabric8.kubernetes.api.model.v2_3.extensions.ScaleSpecFluentImpl;

public class ScaleSpecBuilder
extends ScaleSpecFluentImpl<ScaleSpecBuilder>
implements VisitableBuilder<ScaleSpec, ScaleSpecBuilder> {
    ScaleSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ScaleSpecBuilder() {
        this(true);
    }

    public ScaleSpecBuilder(Boolean validationEnabled) {
        this(new ScaleSpec(), validationEnabled);
    }

    public ScaleSpecBuilder(ScaleSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ScaleSpecBuilder(ScaleSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ScaleSpec(), validationEnabled);
    }

    public ScaleSpecBuilder(ScaleSpecFluent<?> fluent, ScaleSpec instance) {
        this(fluent, instance, true);
    }

    public ScaleSpecBuilder(ScaleSpecFluent<?> fluent, ScaleSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withReplicas(instance.getReplicas());
        this.validationEnabled = validationEnabled;
    }

    public ScaleSpecBuilder(ScaleSpec instance) {
        this(instance, (Boolean)true);
    }

    public ScaleSpecBuilder(ScaleSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withReplicas(instance.getReplicas());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ScaleSpec build() {
        ScaleSpec buildable = new ScaleSpec(this.fluent.getReplicas());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScaleSpecBuilder that = (ScaleSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

