/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_3.extensions;

import io.fabric8.kubernetes.api.builder.v2_3.BaseFluent;
import io.fabric8.kubernetes.api.builder.v2_3.Nested;
import io.fabric8.kubernetes.api.builder.v2_3.Predicate;
import io.fabric8.kubernetes.api.model.v2_3.LabelSelector;
import io.fabric8.kubernetes.api.model.v2_3.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v2_3.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.v2_3.extensions.NetworkPolicyIngressRule;
import io.fabric8.kubernetes.api.model.v2_3.extensions.NetworkPolicyIngressRuleBuilder;
import io.fabric8.kubernetes.api.model.v2_3.extensions.NetworkPolicyIngressRuleFluentImpl;
import io.fabric8.kubernetes.api.model.v2_3.extensions.NetworkPolicySpec;
import io.fabric8.kubernetes.api.model.v2_3.extensions.NetworkPolicySpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NetworkPolicySpecFluentImpl<A extends NetworkPolicySpecFluent<A>>
extends BaseFluent<A>
implements NetworkPolicySpecFluent<A> {
    private List<NetworkPolicyIngressRuleBuilder> ingress = new ArrayList<NetworkPolicyIngressRuleBuilder>();
    private LabelSelectorBuilder podSelector;

    public NetworkPolicySpecFluentImpl() {
    }

    public NetworkPolicySpecFluentImpl(NetworkPolicySpec instance) {
        this.withIngress(instance.getIngress());
        this.withPodSelector(instance.getPodSelector());
    }

    @Override
    public A addToIngress(int index, NetworkPolicyIngressRule item) {
        NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.ingress.add(index >= 0 ? index : this.ingress.size(), builder);
        return (A)this;
    }

    @Override
    public A setToIngress(int index, NetworkPolicyIngressRule item) {
        NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.ingress.size()) {
            this.ingress.add(builder);
        } else {
            this.ingress.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToIngress(NetworkPolicyIngressRule ... items) {
        for (NetworkPolicyIngressRule item : items) {
            NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);
            this._visitables.add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToIngress(Collection<NetworkPolicyIngressRule> items) {
        for (NetworkPolicyIngressRule item : items) {
            NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);
            this._visitables.add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromIngress(NetworkPolicyIngressRule ... items) {
        for (NetworkPolicyIngressRule item : items) {
            NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);
            this._visitables.remove(builder);
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIngress(Collection<NetworkPolicyIngressRule> items) {
        for (NetworkPolicyIngressRule item : items) {
            NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);
            this._visitables.remove(builder);
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NetworkPolicyIngressRule> getIngress() {
        return NetworkPolicySpecFluentImpl.build(this.ingress);
    }

    @Override
    public List<NetworkPolicyIngressRule> buildIngress() {
        return NetworkPolicySpecFluentImpl.build(this.ingress);
    }

    @Override
    public NetworkPolicyIngressRule buildIngress(int index) {
        return this.ingress.get(index).build();
    }

    @Override
    public NetworkPolicyIngressRule buildFirstIngress() {
        return this.ingress.get(0).build();
    }

    @Override
    public NetworkPolicyIngressRule buildLastIngress() {
        return this.ingress.get(this.ingress.size() - 1).build();
    }

    @Override
    public NetworkPolicyIngressRule buildMatchingIngress(Predicate<NetworkPolicyIngressRuleBuilder> predicate) {
        for (NetworkPolicyIngressRuleBuilder item : this.ingress) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withIngress(List<NetworkPolicyIngressRule> ingress) {
        this._visitables.removeAll(this.ingress);
        this.ingress.clear();
        if (ingress != null) {
            for (NetworkPolicyIngressRule item : ingress) {
                this.addToIngress(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withIngress(NetworkPolicyIngressRule ... ingress) {
        this.ingress.clear();
        if (ingress != null) {
            for (NetworkPolicyIngressRule item : ingress) {
                this.addToIngress(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIngress() {
        return this.ingress != null && !this.ingress.isEmpty();
    }

    @Override
    public NetworkPolicySpecFluent.IngressNested<A> addNewIngress() {
        return new IngressNestedImpl();
    }

    @Override
    public NetworkPolicySpecFluent.IngressNested<A> addNewIngressLike(NetworkPolicyIngressRule item) {
        return new IngressNestedImpl(-1, item);
    }

    @Override
    public NetworkPolicySpecFluent.IngressNested<A> setNewIngressLike(int index, NetworkPolicyIngressRule item) {
        return new IngressNestedImpl(index, item);
    }

    @Override
    public NetworkPolicySpecFluent.IngressNested<A> editIngress(int index) {
        if (this.ingress.size() <= index) {
            throw new RuntimeException("Can't edit ingress. Index exceeds size.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public NetworkPolicySpecFluent.IngressNested<A> editFirstIngress() {
        if (this.ingress.size() == 0) {
            throw new RuntimeException("Can't edit first ingress. The list is empty.");
        }
        return this.setNewIngressLike(0, this.buildIngress(0));
    }

    @Override
    public NetworkPolicySpecFluent.IngressNested<A> editLastIngress() {
        int index = this.ingress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ingress. The list is empty.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public NetworkPolicySpecFluent.IngressNested<A> editMatchingIngress(Predicate<NetworkPolicyIngressRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ingress.size(); ++i) {
            if (!predicate.apply(this.ingress.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ingress. No match found.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    @Deprecated
    public LabelSelector getPodSelector() {
        return this.podSelector != null ? this.podSelector.build() : null;
    }

    @Override
    public LabelSelector buildPodSelector() {
        return this.podSelector != null ? this.podSelector.build() : null;
    }

    @Override
    public A withPodSelector(LabelSelector podSelector) {
        this._visitables.remove(this.podSelector);
        if (podSelector != null) {
            this.podSelector = new LabelSelectorBuilder(podSelector);
            this._visitables.add(this.podSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPodSelector() {
        return this.podSelector != null;
    }

    @Override
    public NetworkPolicySpecFluent.PodSelectorNested<A> withNewPodSelector() {
        return new PodSelectorNestedImpl();
    }

    @Override
    public NetworkPolicySpecFluent.PodSelectorNested<A> withNewPodSelectorLike(LabelSelector item) {
        return new PodSelectorNestedImpl(item);
    }

    @Override
    public NetworkPolicySpecFluent.PodSelectorNested<A> editPodSelector() {
        return this.withNewPodSelectorLike(this.getPodSelector());
    }

    @Override
    public NetworkPolicySpecFluent.PodSelectorNested<A> editOrNewPodSelector() {
        return this.withNewPodSelectorLike(this.getPodSelector() != null ? this.getPodSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public NetworkPolicySpecFluent.PodSelectorNested<A> editOrNewPodSelectorLike(LabelSelector item) {
        return this.withNewPodSelectorLike(this.getPodSelector() != null ? this.getPodSelector() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkPolicySpecFluentImpl that = (NetworkPolicySpecFluentImpl)o;
        if (this.ingress != null ? !this.ingress.equals(that.ingress) : that.ingress != null) {
            return false;
        }
        return !(this.podSelector != null ? !this.podSelector.equals(that.podSelector) : that.podSelector != null);
    }

    public class PodSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<NetworkPolicySpecFluent.PodSelectorNested<N>>
    implements NetworkPolicySpecFluent.PodSelectorNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;

        PodSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        PodSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkPolicySpecFluentImpl.this.withPodSelector(this.builder.build());
        }

        @Override
        public N endPodSelector() {
            return this.and();
        }
    }

    public class IngressNestedImpl<N>
    extends NetworkPolicyIngressRuleFluentImpl<NetworkPolicySpecFluent.IngressNested<N>>
    implements NetworkPolicySpecFluent.IngressNested<N>,
    Nested<N> {
        private final NetworkPolicyIngressRuleBuilder builder;
        private final int index;

        IngressNestedImpl(int index, NetworkPolicyIngressRule item) {
            this.index = index;
            this.builder = new NetworkPolicyIngressRuleBuilder(this, item);
        }

        IngressNestedImpl() {
            this.index = -1;
            this.builder = new NetworkPolicyIngressRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkPolicySpecFluentImpl.this.setToIngress(this.index, this.builder.build());
        }

        @Override
        public N endIngress() {
            return this.and();
        }
    }
}

