/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_3.extensions;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.v2_3.KubernetesResource;
import io.fabric8.kubernetes.api.model.v2_3.extensions.IngressBackend;
import io.fabric8.kubernetes.api.model.v2_3.extensions.IngressRule;
import io.fabric8.kubernetes.api.model.v2_3.extensions.IngressTLS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "backend", "rules", "tls"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class IngressSpec
implements KubernetesResource {
    @JsonProperty(value="backend")
    @Valid
    private IngressBackend backend;
    @JsonProperty(value="rules")
    @Valid
    private List<IngressRule> rules = new ArrayList<IngressRule>();
    @JsonProperty(value="tls")
    @Valid
    private List<IngressTLS> tls = new ArrayList<IngressTLS>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public IngressSpec() {
    }

    public IngressSpec(IngressBackend backend, List<IngressRule> rules, List<IngressTLS> tls) {
        this.backend = backend;
        this.rules = rules;
        this.tls = tls;
    }

    @JsonProperty(value="backend")
    public IngressBackend getBackend() {
        return this.backend;
    }

    @JsonProperty(value="backend")
    public void setBackend(IngressBackend backend) {
        this.backend = backend;
    }

    @JsonProperty(value="rules")
    public List<IngressRule> getRules() {
        return this.rules;
    }

    @JsonProperty(value="rules")
    public void setRules(List<IngressRule> rules) {
        this.rules = rules;
    }

    @JsonProperty(value="tls")
    public List<IngressTLS> getTls() {
        return this.tls;
    }

    @JsonProperty(value="tls")
    public void setTls(List<IngressTLS> tls) {
        this.tls = tls;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "IngressSpec(backend=" + this.getBackend() + ", rules=" + this.getRules() + ", tls=" + this.getTls() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IngressSpec)) {
            return false;
        }
        IngressSpec other = (IngressSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IngressBackend this$backend = this.getBackend();
        IngressBackend other$backend = other.getBackend();
        if (this$backend == null ? other$backend != null : !((Object)this$backend).equals(other$backend)) {
            return false;
        }
        List<IngressRule> this$rules = this.getRules();
        List<IngressRule> other$rules = other.getRules();
        if (this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules)) {
            return false;
        }
        List<IngressTLS> this$tls = this.getTls();
        List<IngressTLS> other$tls = other.getTls();
        if (this$tls == null ? other$tls != null : !((Object)this$tls).equals(other$tls)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IngressSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IngressBackend $backend = this.getBackend();
        result = result * 59 + ($backend == null ? 43 : ((Object)$backend).hashCode());
        List<IngressRule> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        List<IngressTLS> $tls = this.getTls();
        result = result * 59 + ($tls == null ? 43 : ((Object)$tls).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

