/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_3.extensions;

import io.fabric8.kubernetes.api.builder.v2_3.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v2_3.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v2_3.extensions.DaemonSetStatus;
import io.fabric8.kubernetes.api.model.v2_3.extensions.DaemonSetStatusFluent;
import io.fabric8.kubernetes.api.model.v2_3.extensions.DaemonSetStatusFluentImpl;

public class DaemonSetStatusBuilder
extends DaemonSetStatusFluentImpl<DaemonSetStatusBuilder>
implements VisitableBuilder<DaemonSetStatus, DaemonSetStatusBuilder> {
    DaemonSetStatusFluent<?> fluent;
    Boolean validationEnabled;

    public DaemonSetStatusBuilder() {
        this(true);
    }

    public DaemonSetStatusBuilder(Boolean validationEnabled) {
        this(new DaemonSetStatus(), validationEnabled);
    }

    public DaemonSetStatusBuilder(DaemonSetStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public DaemonSetStatusBuilder(DaemonSetStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new DaemonSetStatus(), validationEnabled);
    }

    public DaemonSetStatusBuilder(DaemonSetStatusFluent<?> fluent, DaemonSetStatus instance) {
        this(fluent, instance, true);
    }

    public DaemonSetStatusBuilder(DaemonSetStatusFluent<?> fluent, DaemonSetStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCurrentNumberScheduled(instance.getCurrentNumberScheduled());
        fluent.withDesiredNumberScheduled(instance.getDesiredNumberScheduled());
        fluent.withNumberMisscheduled(instance.getNumberMisscheduled());
        fluent.withNumberReady(instance.getNumberReady());
        this.validationEnabled = validationEnabled;
    }

    public DaemonSetStatusBuilder(DaemonSetStatus instance) {
        this(instance, (Boolean)true);
    }

    public DaemonSetStatusBuilder(DaemonSetStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCurrentNumberScheduled(instance.getCurrentNumberScheduled());
        this.withDesiredNumberScheduled(instance.getDesiredNumberScheduled());
        this.withNumberMisscheduled(instance.getNumberMisscheduled());
        this.withNumberReady(instance.getNumberReady());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public DaemonSetStatus build() {
        DaemonSetStatus buildable = new DaemonSetStatus(this.fluent.getCurrentNumberScheduled(), this.fluent.getDesiredNumberScheduled(), this.fluent.getNumberMisscheduled(), this.fluent.getNumberReady());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DaemonSetStatusBuilder that = (DaemonSetStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

