/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_3;

import io.fabric8.kubernetes.api.builder.v2_3.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v2_3.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v2_3.Volume;
import io.fabric8.kubernetes.api.model.v2_3.VolumeFluent;
import io.fabric8.kubernetes.api.model.v2_3.VolumeFluentImpl;

public class VolumeBuilder
extends VolumeFluentImpl<VolumeBuilder>
implements VisitableBuilder<Volume, VolumeBuilder> {
    VolumeFluent<?> fluent;
    Boolean validationEnabled;

    public VolumeBuilder() {
        this(true);
    }

    public VolumeBuilder(Boolean validationEnabled) {
        this(new Volume(), validationEnabled);
    }

    public VolumeBuilder(VolumeFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public VolumeBuilder(VolumeFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Volume(), validationEnabled);
    }

    public VolumeBuilder(VolumeFluent<?> fluent, Volume instance) {
        this(fluent, instance, true);
    }

    public VolumeBuilder(VolumeFluent<?> fluent, Volume instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
        fluent.withAzureDisk(instance.getAzureDisk());
        fluent.withAzureFile(instance.getAzureFile());
        fluent.withCephfs(instance.getCephfs());
        fluent.withCinder(instance.getCinder());
        fluent.withConfigMap(instance.getConfigMap());
        fluent.withDownwardAPI(instance.getDownwardAPI());
        fluent.withEmptyDir(instance.getEmptyDir());
        fluent.withFc(instance.getFc());
        fluent.withFlexVolume(instance.getFlexVolume());
        fluent.withFlocker(instance.getFlocker());
        fluent.withGcePersistentDisk(instance.getGcePersistentDisk());
        fluent.withGitRepo(instance.getGitRepo());
        fluent.withGlusterfs(instance.getGlusterfs());
        fluent.withHostPath(instance.getHostPath());
        fluent.withIscsi(instance.getIscsi());
        fluent.withMetadata(instance.getMetadata());
        fluent.withName(instance.getName());
        fluent.withNfs(instance.getNfs());
        fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        fluent.withPhotonPersistentDisk(instance.getPhotonPersistentDisk());
        fluent.withQuobyte(instance.getQuobyte());
        fluent.withRbd(instance.getRbd());
        fluent.withSecret(instance.getSecret());
        fluent.withVsphereVolume(instance.getVsphereVolume());
        this.validationEnabled = validationEnabled;
    }

    public VolumeBuilder(Volume instance) {
        this(instance, (Boolean)true);
    }

    public VolumeBuilder(Volume instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
        this.withAzureDisk(instance.getAzureDisk());
        this.withAzureFile(instance.getAzureFile());
        this.withCephfs(instance.getCephfs());
        this.withCinder(instance.getCinder());
        this.withConfigMap(instance.getConfigMap());
        this.withDownwardAPI(instance.getDownwardAPI());
        this.withEmptyDir(instance.getEmptyDir());
        this.withFc(instance.getFc());
        this.withFlexVolume(instance.getFlexVolume());
        this.withFlocker(instance.getFlocker());
        this.withGcePersistentDisk(instance.getGcePersistentDisk());
        this.withGitRepo(instance.getGitRepo());
        this.withGlusterfs(instance.getGlusterfs());
        this.withHostPath(instance.getHostPath());
        this.withIscsi(instance.getIscsi());
        this.withMetadata(instance.getMetadata());
        this.withName(instance.getName());
        this.withNfs(instance.getNfs());
        this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        this.withPhotonPersistentDisk(instance.getPhotonPersistentDisk());
        this.withQuobyte(instance.getQuobyte());
        this.withRbd(instance.getRbd());
        this.withSecret(instance.getSecret());
        this.withVsphereVolume(instance.getVsphereVolume());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Volume build() {
        Volume buildable = new Volume(this.fluent.getAwsElasticBlockStore(), this.fluent.getAzureDisk(), this.fluent.getAzureFile(), this.fluent.getCephfs(), this.fluent.getCinder(), this.fluent.getConfigMap(), this.fluent.getDownwardAPI(), this.fluent.getEmptyDir(), this.fluent.getFc(), this.fluent.getFlexVolume(), this.fluent.getFlocker(), this.fluent.getGcePersistentDisk(), this.fluent.getGitRepo(), this.fluent.getGlusterfs(), this.fluent.getHostPath(), this.fluent.getIscsi(), this.fluent.getMetadata(), this.fluent.getName(), this.fluent.getNfs(), this.fluent.getPersistentVolumeClaim(), this.fluent.getPhotonPersistentDisk(), this.fluent.getQuobyte(), this.fluent.getRbd(), this.fluent.getSecret(), this.fluent.getVsphereVolume());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VolumeBuilder that = (VolumeBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

