/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_3;

import io.fabric8.kubernetes.api.builder.v2_3.BaseFluent;
import io.fabric8.kubernetes.api.builder.v2_3.Nested;
import io.fabric8.kubernetes.api.model.v2_3.ObjectMeta;
import io.fabric8.kubernetes.api.model.v2_3.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v2_3.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.v2_3.Service;
import io.fabric8.kubernetes.api.model.v2_3.ServiceFluent;
import io.fabric8.kubernetes.api.model.v2_3.ServiceSpec;
import io.fabric8.kubernetes.api.model.v2_3.ServiceSpecBuilder;
import io.fabric8.kubernetes.api.model.v2_3.ServiceSpecFluentImpl;
import io.fabric8.kubernetes.api.model.v2_3.ServiceStatus;
import io.fabric8.kubernetes.api.model.v2_3.ServiceStatusBuilder;
import io.fabric8.kubernetes.api.model.v2_3.ServiceStatusFluentImpl;

public class ServiceFluentImpl<A extends ServiceFluent<A>>
extends BaseFluent<A>
implements ServiceFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ServiceSpecBuilder spec;
    private ServiceStatusBuilder status;

    public ServiceFluentImpl() {
    }

    public ServiceFluentImpl(Service instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ServiceFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ServiceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ServiceFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ServiceFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ServiceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public ServiceSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public ServiceSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(ServiceSpec spec) {
        this._visitables.remove(this.spec);
        if (spec != null) {
            this.spec = new ServiceSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public ServiceFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public ServiceFluent.SpecNested<A> withNewSpecLike(ServiceSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public ServiceFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public ServiceFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new ServiceSpecBuilder().build());
    }

    @Override
    public ServiceFluent.SpecNested<A> editOrNewSpecLike(ServiceSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public ServiceStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public ServiceStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(ServiceStatus status) {
        this._visitables.remove(this.status);
        if (status != null) {
            this.status = new ServiceStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public ServiceFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public ServiceFluent.StatusNested<A> withNewStatusLike(ServiceStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public ServiceFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public ServiceFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new ServiceStatusBuilder().build());
    }

    @Override
    public ServiceFluent.StatusNested<A> editOrNewStatusLike(ServiceStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceFluentImpl that = (ServiceFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends ServiceStatusFluentImpl<ServiceFluent.StatusNested<N>>
    implements ServiceFluent.StatusNested<N>,
    Nested<N> {
        private final ServiceStatusBuilder builder;

        StatusNestedImpl(ServiceStatus item) {
            this.builder = new ServiceStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new ServiceStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends ServiceSpecFluentImpl<ServiceFluent.SpecNested<N>>
    implements ServiceFluent.SpecNested<N>,
    Nested<N> {
        private final ServiceSpecBuilder builder;

        SpecNestedImpl(ServiceSpec item) {
            this.builder = new ServiceSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new ServiceSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ServiceFluent.MetadataNested<N>>
    implements ServiceFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

