/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_3;

import io.fabric8.kubernetes.api.builder.v2_3.BaseFluent;
import io.fabric8.kubernetes.api.builder.v2_3.Nested;
import io.fabric8.kubernetes.api.model.v2_3.DeleteOptions;
import io.fabric8.kubernetes.api.model.v2_3.DeleteOptionsFluent;
import io.fabric8.kubernetes.api.model.v2_3.Preconditions;
import io.fabric8.kubernetes.api.model.v2_3.PreconditionsBuilder;
import io.fabric8.kubernetes.api.model.v2_3.PreconditionsFluentImpl;

public class DeleteOptionsFluentImpl<A extends DeleteOptionsFluent<A>>
extends BaseFluent<A>
implements DeleteOptionsFluent<A> {
    private String apiVersion;
    private Long gracePeriodSeconds;
    private String kind;
    private Boolean orphanDependents;
    private PreconditionsBuilder preconditions;

    public DeleteOptionsFluentImpl() {
    }

    public DeleteOptionsFluentImpl(DeleteOptions instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withGracePeriodSeconds(instance.getGracePeriodSeconds());
        this.withKind(instance.getKind());
        this.withOrphanDependents(instance.getOrphanDependents());
        this.withPreconditions(instance.getPreconditions());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public Long getGracePeriodSeconds() {
        return this.gracePeriodSeconds;
    }

    @Override
    public A withGracePeriodSeconds(Long gracePeriodSeconds) {
        this.gracePeriodSeconds = gracePeriodSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasGracePeriodSeconds() {
        return this.gracePeriodSeconds != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public Boolean isOrphanDependents() {
        return this.orphanDependents;
    }

    @Override
    public A withOrphanDependents(Boolean orphanDependents) {
        this.orphanDependents = orphanDependents;
        return (A)this;
    }

    @Override
    public Boolean hasOrphanDependents() {
        return this.orphanDependents != null;
    }

    @Override
    @Deprecated
    public Preconditions getPreconditions() {
        return this.preconditions != null ? this.preconditions.build() : null;
    }

    @Override
    public Preconditions buildPreconditions() {
        return this.preconditions != null ? this.preconditions.build() : null;
    }

    @Override
    public A withPreconditions(Preconditions preconditions) {
        this._visitables.remove(this.preconditions);
        if (preconditions != null) {
            this.preconditions = new PreconditionsBuilder(preconditions);
            this._visitables.add(this.preconditions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPreconditions() {
        return this.preconditions != null;
    }

    @Override
    public DeleteOptionsFluent.PreconditionsNested<A> withNewPreconditions() {
        return new PreconditionsNestedImpl();
    }

    @Override
    public DeleteOptionsFluent.PreconditionsNested<A> withNewPreconditionsLike(Preconditions item) {
        return new PreconditionsNestedImpl(item);
    }

    @Override
    public DeleteOptionsFluent.PreconditionsNested<A> editPreconditions() {
        return this.withNewPreconditionsLike(this.getPreconditions());
    }

    @Override
    public DeleteOptionsFluent.PreconditionsNested<A> editOrNewPreconditions() {
        return this.withNewPreconditionsLike(this.getPreconditions() != null ? this.getPreconditions() : new PreconditionsBuilder().build());
    }

    @Override
    public DeleteOptionsFluent.PreconditionsNested<A> editOrNewPreconditionsLike(Preconditions item) {
        return this.withNewPreconditionsLike(this.getPreconditions() != null ? this.getPreconditions() : item);
    }

    @Override
    public A withNewPreconditions(String uid) {
        return this.withPreconditions(new Preconditions(uid));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeleteOptionsFluentImpl that = (DeleteOptionsFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.gracePeriodSeconds != null ? !this.gracePeriodSeconds.equals(that.gracePeriodSeconds) : that.gracePeriodSeconds != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.orphanDependents != null ? !this.orphanDependents.equals(that.orphanDependents) : that.orphanDependents != null) {
            return false;
        }
        return !(this.preconditions != null ? !this.preconditions.equals(that.preconditions) : that.preconditions != null);
    }

    public class PreconditionsNestedImpl<N>
    extends PreconditionsFluentImpl<DeleteOptionsFluent.PreconditionsNested<N>>
    implements DeleteOptionsFluent.PreconditionsNested<N>,
    Nested<N> {
        private final PreconditionsBuilder builder;

        PreconditionsNestedImpl(Preconditions item) {
            this.builder = new PreconditionsBuilder(this, item);
        }

        PreconditionsNestedImpl() {
            this.builder = new PreconditionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeleteOptionsFluentImpl.this.withPreconditions(this.builder.build());
        }

        @Override
        public N endPreconditions() {
            return this.and();
        }
    }
}

