/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v2_2.osgi;

import io.fabric8.kubernetes.api.model.v2_2.ComponentStatus;
import io.fabric8.kubernetes.api.model.v2_2.ComponentStatusList;
import io.fabric8.kubernetes.api.model.v2_2.ConfigMap;
import io.fabric8.kubernetes.api.model.v2_2.ConfigMapList;
import io.fabric8.kubernetes.api.model.v2_2.DoneableComponentStatus;
import io.fabric8.kubernetes.api.model.v2_2.DoneableConfigMap;
import io.fabric8.kubernetes.api.model.v2_2.DoneableEndpoints;
import io.fabric8.kubernetes.api.model.v2_2.DoneableEvent;
import io.fabric8.kubernetes.api.model.v2_2.DoneableLimitRange;
import io.fabric8.kubernetes.api.model.v2_2.DoneableNamespace;
import io.fabric8.kubernetes.api.model.v2_2.DoneableNode;
import io.fabric8.kubernetes.api.model.v2_2.DoneablePersistentVolume;
import io.fabric8.kubernetes.api.model.v2_2.DoneablePersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.v2_2.DoneablePod;
import io.fabric8.kubernetes.api.model.v2_2.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.v2_2.DoneableResourceQuota;
import io.fabric8.kubernetes.api.model.v2_2.DoneableSecret;
import io.fabric8.kubernetes.api.model.v2_2.DoneableSecurityContextConstraints;
import io.fabric8.kubernetes.api.model.v2_2.DoneableService;
import io.fabric8.kubernetes.api.model.v2_2.DoneableServiceAccount;
import io.fabric8.kubernetes.api.model.v2_2.Endpoints;
import io.fabric8.kubernetes.api.model.v2_2.EndpointsList;
import io.fabric8.kubernetes.api.model.v2_2.Event;
import io.fabric8.kubernetes.api.model.v2_2.EventList;
import io.fabric8.kubernetes.api.model.v2_2.HasMetadata;
import io.fabric8.kubernetes.api.model.v2_2.KubernetesList;
import io.fabric8.kubernetes.api.model.v2_2.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v2_2.LimitRange;
import io.fabric8.kubernetes.api.model.v2_2.LimitRangeList;
import io.fabric8.kubernetes.api.model.v2_2.Namespace;
import io.fabric8.kubernetes.api.model.v2_2.NamespaceList;
import io.fabric8.kubernetes.api.model.v2_2.Node;
import io.fabric8.kubernetes.api.model.v2_2.NodeList;
import io.fabric8.kubernetes.api.model.v2_2.PersistentVolume;
import io.fabric8.kubernetes.api.model.v2_2.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.v2_2.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.v2_2.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.v2_2.Pod;
import io.fabric8.kubernetes.api.model.v2_2.PodList;
import io.fabric8.kubernetes.api.model.v2_2.ReplicationController;
import io.fabric8.kubernetes.api.model.v2_2.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.v2_2.ResourceQuota;
import io.fabric8.kubernetes.api.model.v2_2.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.v2_2.RootPaths;
import io.fabric8.kubernetes.api.model.v2_2.Secret;
import io.fabric8.kubernetes.api.model.v2_2.SecretList;
import io.fabric8.kubernetes.api.model.v2_2.SecurityContextConstraints;
import io.fabric8.kubernetes.api.model.v2_2.SecurityContextConstraintsList;
import io.fabric8.kubernetes.api.model.v2_2.ServiceAccount;
import io.fabric8.kubernetes.api.model.v2_2.ServiceAccountList;
import io.fabric8.kubernetes.api.model.v2_2.ServiceList;
import io.fabric8.kubernetes.clnt.v2_2.BaseClient;
import io.fabric8.kubernetes.clnt.v2_2.Config;
import io.fabric8.kubernetes.clnt.v2_2.RequestConfig;
import io.fabric8.kubernetes.clnt.v2_2.dsl.ExtensionsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v2_2.dsl.FunctionCallable;
import io.fabric8.kubernetes.clnt.v2_2.dsl.KubernetesListMixedOperation;
import io.fabric8.kubernetes.clnt.v2_2.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v2_2.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v2_2.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v2_2.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v2_2.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v2_2.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v2_2.dsl.Resource;
import io.fabric8.kubernetes.clnt.v2_2.dsl.RollableScallableResource;
import io.fabric8.kubernetes.clnt.v2_2.utils.URLUtils;
import io.fabric8.openshift.api.model.v2_2.Build;
import io.fabric8.openshift.api.model.v2_2.BuildConfig;
import io.fabric8.openshift.api.model.v2_2.BuildConfigList;
import io.fabric8.openshift.api.model.v2_2.BuildList;
import io.fabric8.openshift.api.model.v2_2.ClusterRoleBinding;
import io.fabric8.openshift.api.model.v2_2.ClusterRoleBindingList;
import io.fabric8.openshift.api.model.v2_2.DeploymentConfig;
import io.fabric8.openshift.api.model.v2_2.DeploymentConfigList;
import io.fabric8.openshift.api.model.v2_2.DoneableBuild;
import io.fabric8.openshift.api.model.v2_2.DoneableBuildConfig;
import io.fabric8.openshift.api.model.v2_2.DoneableClusterRoleBinding;
import io.fabric8.openshift.api.model.v2_2.DoneableDeploymentConfig;
import io.fabric8.openshift.api.model.v2_2.DoneableGroup;
import io.fabric8.openshift.api.model.v2_2.DoneableImageStream;
import io.fabric8.openshift.api.model.v2_2.DoneableImageStreamTag;
import io.fabric8.openshift.api.model.v2_2.DoneableOAuthAccessToken;
import io.fabric8.openshift.api.model.v2_2.DoneableOAuthAuthorizeToken;
import io.fabric8.openshift.api.model.v2_2.DoneableOAuthClient;
import io.fabric8.openshift.api.model.v2_2.DoneablePolicy;
import io.fabric8.openshift.api.model.v2_2.DoneablePolicyBinding;
import io.fabric8.openshift.api.model.v2_2.DoneableProject;
import io.fabric8.openshift.api.model.v2_2.DoneableRole;
import io.fabric8.openshift.api.model.v2_2.DoneableRoleBinding;
import io.fabric8.openshift.api.model.v2_2.DoneableRoute;
import io.fabric8.openshift.api.model.v2_2.DoneableTemplate;
import io.fabric8.openshift.api.model.v2_2.DoneableUser;
import io.fabric8.openshift.api.model.v2_2.Group;
import io.fabric8.openshift.api.model.v2_2.GroupList;
import io.fabric8.openshift.api.model.v2_2.ImageStream;
import io.fabric8.openshift.api.model.v2_2.ImageStreamList;
import io.fabric8.openshift.api.model.v2_2.ImageStreamTag;
import io.fabric8.openshift.api.model.v2_2.ImageStreamTagList;
import io.fabric8.openshift.api.model.v2_2.OAuthAccessToken;
import io.fabric8.openshift.api.model.v2_2.OAuthAccessTokenList;
import io.fabric8.openshift.api.model.v2_2.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.v2_2.OAuthAuthorizeTokenList;
import io.fabric8.openshift.api.model.v2_2.OAuthClient;
import io.fabric8.openshift.api.model.v2_2.OAuthClientList;
import io.fabric8.openshift.api.model.v2_2.Policy;
import io.fabric8.openshift.api.model.v2_2.PolicyBinding;
import io.fabric8.openshift.api.model.v2_2.PolicyBindingList;
import io.fabric8.openshift.api.model.v2_2.PolicyList;
import io.fabric8.openshift.api.model.v2_2.Project;
import io.fabric8.openshift.api.model.v2_2.ProjectList;
import io.fabric8.openshift.api.model.v2_2.Role;
import io.fabric8.openshift.api.model.v2_2.RoleBinding;
import io.fabric8.openshift.api.model.v2_2.RoleBindingList;
import io.fabric8.openshift.api.model.v2_2.RoleList;
import io.fabric8.openshift.api.model.v2_2.Route;
import io.fabric8.openshift.api.model.v2_2.RouteList;
import io.fabric8.openshift.api.model.v2_2.Template;
import io.fabric8.openshift.api.model.v2_2.TemplateList;
import io.fabric8.openshift.api.model.v2_2.User;
import io.fabric8.openshift.api.model.v2_2.UserList;
import io.fabric8.openshift.clnt.v2_2.DefaultOpenShiftClient;
import io.fabric8.openshift.clnt.v2_2.NamespacedOpenShiftClient;
import io.fabric8.openshift.clnt.v2_2.OpenShiftClient;
import io.fabric8.openshift.clnt.v2_2.OpenShiftConfig;
import io.fabric8.openshift.clnt.v2_2.OpenShiftConfigBuilder;
import io.fabric8.openshift.clnt.v2_2.dsl.BuildConfigResource;
import io.fabric8.openshift.clnt.v2_2.dsl.BuildResource;
import io.fabric8.openshift.clnt.v2_2.dsl.CreateableLocalSubjectAccessReview;
import io.fabric8.openshift.clnt.v2_2.dsl.CreateableSubjectAccessReview;
import io.fabric8.openshift.clnt.v2_2.dsl.DeployableScalableResource;
import io.fabric8.openshift.clnt.v2_2.dsl.ProjectRequestOperation;
import io.fabric8.openshift.clnt.v2_2.dsl.SubjectAccessReviewOperation;
import io.fabric8.openshift.clnt.v2_2.dsl.TemplateResource;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;

@Component(immediate=true, configurationPid="io.fabric8.openshift.clnt.v2_2", policy=ConfigurationPolicy.OPTIONAL)
@Service(value={OpenShiftClient.class, NamespacedOpenShiftClient.class})
public class ManagedOpenShiftClient
extends BaseClient
implements NamespacedOpenShiftClient {
    private DefaultOpenShiftClient delegate;

    @Activate
    public void activate(Map<String, Object> properties) {
        OpenShiftConfigBuilder builder = new OpenShiftConfigBuilder();
        if (properties.containsKey("kubernetes.master")) {
            builder.withMasterUrl((String)properties.get("kubernetes.master"));
        }
        if (properties.containsKey("kubernetes.api.version")) {
            builder.withApiVersion((String)properties.get("kubernetes.api.version"));
        }
        if (properties.containsKey("kubernetes.namespace")) {
            builder.withNamespace((String)properties.get("kubernetes.namespace"));
        }
        if (properties.containsKey("kubernetes.certs.ca.file")) {
            builder.withCaCertFile((String)properties.get("kubernetes.certs.ca.file"));
        }
        if (properties.containsKey("kubernetes.certs.ca.data")) {
            builder.withCaCertData((String)properties.get("kubernetes.certs.ca.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.file")) {
            builder.withClientCertFile((String)properties.get("kubernetes.certs.client.file"));
        }
        if (properties.containsKey("kubernetes.certs.client.data")) {
            builder.withClientCertData((String)properties.get("kubernetes.certs.client.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.file")) {
            builder.withClientKeyFile((String)properties.get("kubernetes.certs.client.key.file"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.data")) {
            builder.withClientKeyData((String)properties.get("kubernetes.certs.client.key.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.algo")) {
            builder.withClientKeyAlgo((String)properties.get("kubernetes.certs.client.key.algo"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.passphrase")) {
            builder.withClientKeyPassphrase((String)properties.get("kubernetes.certs.client.key.passphrase"));
        }
        if (properties.containsKey("kubernetes.auth.basic.username")) {
            builder.withUsername((String)properties.get("kubernetes.auth.basic.username"));
        }
        if (properties.containsKey("kubernetes.auth.basic.password")) {
            builder.withPassword((String)properties.get("kubernetes.auth.basic.password"));
        }
        if (properties.containsKey("kubernetes.auth.token")) {
            builder.withOauthToken((String)properties.get("kubernetes.auth.token"));
        }
        if (properties.containsKey("kubernetes.watch.reconnectInterval")) {
            builder.withWatchReconnectInterval(Integer.parseInt((String)properties.get("kubernetes.watch.reconnectInterval")));
        }
        if (properties.containsKey("kubernetes.watch.reconnectLimit")) {
            builder.withWatchReconnectLimit(Integer.parseInt((String)properties.get("kubernetes.watch.reconnectLimit")));
        }
        if (properties.containsKey("kubernetes.request.timeout")) {
            builder.withRequestTimeout(Integer.parseInt((String)properties.get("kubernetes.request.timeout")));
        }
        if (properties.containsKey("http.proxy")) {
            builder.withHttpProxy((String)properties.get("http.proxy"));
        }
        if (properties.containsKey("https.proxy")) {
            builder.withHttpsProxy((String)properties.get("https.proxy"));
        }
        if (properties.containsKey("no.proxy")) {
            String noProxyProperty = (String)properties.get("no.proxy");
            builder.withNoProxy(noProxyProperty.split(","));
        }
        if (properties.containsKey("openshift.url")) {
            builder.withOpenShiftUrl((String)properties.get("openshift.url"));
        } else {
            builder.withOpenShiftUrl(URLUtils.join(builder.getMasterUrl(), "oapi", builder.getOapiVersion()));
        }
        if (properties.containsKey("openshift.build.timeout")) {
            builder.withBuildTimeout(Integer.parseInt((String)properties.get("openshift.build.timeout")));
        } else {
            builder.withBuildTimeout(OpenShiftConfig.DEFAULT_BUILD_TIMEOUT);
        }
        if (properties.containsKey("kubernetes.websocket.timeout")) {
            builder.withWebsocketTimeout(Long.parseLong((String)properties.get("kubernetes.websocket.timeout")));
        }
        if (properties.containsKey("kubernetes.websocket.ping.interval")) {
            builder.withWebsocketPingInterval(Long.parseLong((String)properties.get("kubernetes.websocket.ping.interval")));
        }
        this.delegate = new DefaultOpenShiftClient(builder.build());
    }

    @Deactivate
    public void deactivate() {
        this.delegate.close();
    }

    @Override
    public URL getOpenshiftUrl() {
        return this.delegate.getOpenshiftUrl();
    }

    @Override
    public MixedOperation<Build, BuildList, DoneableBuild, BuildResource<Build, DoneableBuild, String, LogWatch>> builds() {
        return this.delegate.builds();
    }

    @Override
    public MixedOperation<ComponentStatus, ComponentStatusList, DoneableComponentStatus, Resource<ComponentStatus, DoneableComponentStatus>> componentstatuses() {
        return this.delegate.componentstatuses();
    }

    @Override
    public MixedOperation<BuildConfig, BuildConfigList, DoneableBuildConfig, BuildConfigResource<BuildConfig, DoneableBuildConfig, Void, Build>> buildConfigs() {
        return this.delegate.buildConfigs();
    }

    @Override
    public MixedOperation<DeploymentConfig, DeploymentConfigList, DoneableDeploymentConfig, DeployableScalableResource<DeploymentConfig, DoneableDeploymentConfig>> deploymentConfigs() {
        return this.delegate.deploymentConfigs();
    }

    @Override
    public NonNamespaceOperation<Group, GroupList, DoneableGroup, Resource<Group, DoneableGroup>> groups() {
        return this.delegate.groups();
    }

    @Override
    public MixedOperation<ImageStream, ImageStreamList, DoneableImageStream, Resource<ImageStream, DoneableImageStream>> imageStreams() {
        return this.delegate.imageStreams();
    }

    @Override
    public MixedOperation<ImageStreamTag, ImageStreamTagList, DoneableImageStreamTag, Resource<ImageStreamTag, DoneableImageStreamTag>> imageStreamTags() {
        return this.delegate.imageStreamTags();
    }

    @Override
    public NonNamespaceOperation<OAuthAccessToken, OAuthAccessTokenList, DoneableOAuthAccessToken, Resource<OAuthAccessToken, DoneableOAuthAccessToken>> oAuthAccessTokens() {
        return this.delegate.oAuthAccessTokens();
    }

    @Override
    public NonNamespaceOperation<OAuthAuthorizeToken, OAuthAuthorizeTokenList, DoneableOAuthAuthorizeToken, Resource<OAuthAuthorizeToken, DoneableOAuthAuthorizeToken>> oAuthAuthorizeTokens() {
        return this.delegate.oAuthAuthorizeTokens();
    }

    @Override
    public NonNamespaceOperation<OAuthClient, OAuthClientList, DoneableOAuthClient, Resource<OAuthClient, DoneableOAuthClient>> oAuthClients() {
        return this.delegate.oAuthClients();
    }

    @Override
    public MixedOperation<Policy, PolicyList, DoneablePolicy, Resource<Policy, DoneablePolicy>> policies() {
        return this.delegate.policies();
    }

    @Override
    public MixedOperation<PolicyBinding, PolicyBindingList, DoneablePolicyBinding, Resource<PolicyBinding, DoneablePolicyBinding>> policyBindings() {
        return this.delegate.policyBindings();
    }

    @Override
    public NonNamespaceOperation<Project, ProjectList, DoneableProject, Resource<Project, DoneableProject>> projects() {
        return this.delegate.projects();
    }

    @Override
    public ProjectRequestOperation projectrequests() {
        return this.delegate.projectrequests();
    }

    @Override
    public MixedOperation<Role, RoleList, DoneableRole, Resource<Role, DoneableRole>> roles() {
        return this.delegate.roles();
    }

    @Override
    public MixedOperation<RoleBinding, RoleBindingList, DoneableRoleBinding, Resource<RoleBinding, DoneableRoleBinding>> roleBindings() {
        return this.delegate.roleBindings();
    }

    @Override
    public MixedOperation<Route, RouteList, DoneableRoute, Resource<Route, DoneableRoute>> routes() {
        return this.delegate.routes();
    }

    @Override
    public MixedOperation<Template, TemplateList, DoneableTemplate, TemplateResource<Template, KubernetesList, DoneableTemplate>> templates() {
        return this.delegate.templates();
    }

    @Override
    public NonNamespaceOperation<User, UserList, DoneableUser, Resource<User, DoneableUser>> users() {
        return this.delegate.users();
    }

    @Override
    public SubjectAccessReviewOperation<CreateableSubjectAccessReview, CreateableLocalSubjectAccessReview> subjectAccessReviews() {
        return this.delegate.subjectAccessReviews();
    }

    @Override
    public MixedOperation<ClusterRoleBinding, ClusterRoleBindingList, DoneableClusterRoleBinding, Resource<ClusterRoleBinding, DoneableClusterRoleBinding>> clusterRoleBindings() {
        return this.delegate.clusterRoleBindings();
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> load(InputStream is) {
        return this.delegate.load(is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(KubernetesResourceList is) {
        return this.delegate.resourceList(is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(HasMetadata ... items) {
        return this.delegate.resourceList(items);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(Collection<HasMetadata> items) {
        return this.delegate.resourceList(items);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(String s) {
        return this.delegate.resourceList(s);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(HasMetadata item) {
        return this.delegate.resource(item);
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(String s) {
        return this.delegate.resource(s);
    }

    @Override
    public MixedOperation<Endpoints, EndpointsList, DoneableEndpoints, Resource<Endpoints, DoneableEndpoints>> endpoints() {
        return this.delegate.endpoints();
    }

    @Override
    public MixedOperation<Event, EventList, DoneableEvent, Resource<Event, DoneableEvent>> events() {
        return this.delegate.events();
    }

    @Override
    public NonNamespaceOperation<Namespace, NamespaceList, DoneableNamespace, Resource<Namespace, DoneableNamespace>> namespaces() {
        return this.delegate.namespaces();
    }

    @Override
    public NonNamespaceOperation<Node, NodeList, DoneableNode, Resource<Node, DoneableNode>> nodes() {
        return this.delegate.nodes();
    }

    @Override
    public NonNamespaceOperation<PersistentVolume, PersistentVolumeList, DoneablePersistentVolume, Resource<PersistentVolume, DoneablePersistentVolume>> persistentVolumes() {
        return this.delegate.persistentVolumes();
    }

    @Override
    public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, DoneablePersistentVolumeClaim, Resource<PersistentVolumeClaim, DoneablePersistentVolumeClaim>> persistentVolumeClaims() {
        return this.delegate.persistentVolumeClaims();
    }

    @Override
    public MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> pods() {
        return this.delegate.pods();
    }

    @Override
    public MixedOperation<ReplicationController, ReplicationControllerList, DoneableReplicationController, RollableScallableResource<ReplicationController, DoneableReplicationController>> replicationControllers() {
        return this.delegate.replicationControllers();
    }

    @Override
    public MixedOperation<ResourceQuota, ResourceQuotaList, DoneableResourceQuota, Resource<ResourceQuota, DoneableResourceQuota>> resourceQuotas() {
        return this.delegate.resourceQuotas();
    }

    @Override
    public MixedOperation<Secret, SecretList, DoneableSecret, Resource<Secret, DoneableSecret>> secrets() {
        return this.delegate.secrets();
    }

    @Override
    public MixedOperation<io.fabric8.kubernetes.api.model.v2_2.Service, ServiceList, DoneableService, Resource<io.fabric8.kubernetes.api.model.v2_2.Service, DoneableService>> services() {
        return this.delegate.services();
    }

    @Override
    public MixedOperation<ServiceAccount, ServiceAccountList, DoneableServiceAccount, Resource<ServiceAccount, DoneableServiceAccount>> serviceAccounts() {
        return this.delegate.serviceAccounts();
    }

    @Override
    public KubernetesListMixedOperation lists() {
        return this.delegate.lists();
    }

    @Override
    public NonNamespaceOperation<SecurityContextConstraints, SecurityContextConstraintsList, DoneableSecurityContextConstraints, Resource<SecurityContextConstraints, DoneableSecurityContextConstraints>> securityContextConstraints() {
        return this.delegate.securityContextConstraints();
    }

    @Override
    public MixedOperation<ConfigMap, ConfigMapList, DoneableConfigMap, Resource<ConfigMap, DoneableConfigMap>> configMaps() {
        return this.delegate.configMaps();
    }

    @Override
    public MixedOperation<LimitRange, LimitRangeList, DoneableLimitRange, Resource<LimitRange, DoneableLimitRange>> limitRanges() {
        return this.delegate.limitRanges();
    }

    @Override
    public <C> C adapt(Class<C> type) {
        return this.delegate.adapt(type);
    }

    @Override
    public URL getMasterUrl() {
        return this.delegate.getMasterUrl();
    }

    @Override
    public String getApiVersion() {
        return this.delegate.getApiVersion();
    }

    @Override
    public String getNamespace() {
        return this.delegate.getNamespace();
    }

    @Override
    public RootPaths rootPaths() {
        return this.delegate.rootPaths();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public Config getConfiguration() {
        return this.delegate.getConfiguration();
    }

    @Override
    public ExtensionsAPIGroupDSL extensions() {
        return this.delegate.extensions();
    }

    @Override
    public NamespacedOpenShiftClient inAnyNamespace() {
        return this.delegate.inAnyNamespace();
    }

    @Override
    public NamespacedOpenShiftClient inNamespace(String name) {
        return this.delegate.inNamespace(name);
    }

    @Override
    public FunctionCallable<NamespacedOpenShiftClient> withRequestConfig(RequestConfig requestConfig) {
        return this.delegate.withRequestConfig(requestConfig);
    }

    @Override
    public User currentUser() {
        return this.delegate.currentUser();
    }
}

