/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v2_2;

import io.fabric8.kubernetes.api.builder.v2_2.BaseFluent;
import io.fabric8.kubernetes.api.builder.v2_2.Nested;
import io.fabric8.openshift.api.model.v2_2.NamedRole;
import io.fabric8.openshift.api.model.v2_2.NamedRoleFluent;
import io.fabric8.openshift.api.model.v2_2.Role;
import io.fabric8.openshift.api.model.v2_2.RoleBuilder;
import io.fabric8.openshift.api.model.v2_2.RoleFluentImpl;

public class NamedRoleFluentImpl<A extends NamedRoleFluent<A>>
extends BaseFluent<A>
implements NamedRoleFluent<A> {
    private String name;
    private RoleBuilder role;

    public NamedRoleFluentImpl() {
    }

    public NamedRoleFluentImpl(NamedRole instance) {
        this.withName(instance.getName());
        this.withRole(instance.getRole());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public Role getRole() {
        return this.role != null ? this.role.build() : null;
    }

    @Override
    public Role buildRole() {
        return this.role != null ? this.role.build() : null;
    }

    @Override
    public A withRole(Role role) {
        this._visitables.remove(this.role);
        if (role != null) {
            this.role = new RoleBuilder(role);
            this._visitables.add(this.role);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRole() {
        return this.role != null;
    }

    @Override
    public NamedRoleFluent.RoleNested<A> withNewRole() {
        return new RoleNestedImpl();
    }

    @Override
    public NamedRoleFluent.RoleNested<A> withNewRoleLike(Role item) {
        return new RoleNestedImpl(item);
    }

    @Override
    public NamedRoleFluent.RoleNested<A> editRole() {
        return this.withNewRoleLike(this.getRole());
    }

    @Override
    public NamedRoleFluent.RoleNested<A> editOrNewRole() {
        return this.withNewRoleLike(this.getRole() != null ? this.getRole() : new RoleBuilder().build());
    }

    @Override
    public NamedRoleFluent.RoleNested<A> editOrNewRoleLike(Role item) {
        return this.withNewRoleLike(this.getRole() != null ? this.getRole() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedRoleFluentImpl that = (NamedRoleFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.role != null ? !this.role.equals(that.role) : that.role != null);
    }

    public class RoleNestedImpl<N>
    extends RoleFluentImpl<NamedRoleFluent.RoleNested<N>>
    implements NamedRoleFluent.RoleNested<N>,
    Nested<N> {
        private final RoleBuilder builder;

        RoleNestedImpl(Role item) {
            this.builder = new RoleBuilder(this, item);
        }

        RoleNestedImpl() {
            this.builder = new RoleBuilder(this);
        }

        @Override
        public N and() {
            return (N)NamedRoleFluentImpl.this.withRole(this.builder.build());
        }

        @Override
        public N endRole() {
            return this.and();
        }
    }
}

