/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_2;

import io.fabric8.kubernetes.api.builder.v2_2.BaseFluent;
import io.fabric8.kubernetes.api.builder.v2_2.Nested;
import io.fabric8.kubernetes.api.builder.v2_2.Predicate;
import io.fabric8.kubernetes.api.model.v2_2.LoadBalancerIngress;
import io.fabric8.kubernetes.api.model.v2_2.LoadBalancerIngressBuilder;
import io.fabric8.kubernetes.api.model.v2_2.LoadBalancerIngressFluentImpl;
import io.fabric8.kubernetes.api.model.v2_2.LoadBalancerStatus;
import io.fabric8.kubernetes.api.model.v2_2.LoadBalancerStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LoadBalancerStatusFluentImpl<A extends LoadBalancerStatusFluent<A>>
extends BaseFluent<A>
implements LoadBalancerStatusFluent<A> {
    private List<LoadBalancerIngressBuilder> ingress = new ArrayList<LoadBalancerIngressBuilder>();

    public LoadBalancerStatusFluentImpl() {
    }

    public LoadBalancerStatusFluentImpl(LoadBalancerStatus instance) {
        this.withIngress(instance.getIngress());
    }

    @Override
    public A addToIngress(int index, LoadBalancerIngress item) {
        LoadBalancerIngressBuilder builder = new LoadBalancerIngressBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.ingress.add(index >= 0 ? index : this.ingress.size(), builder);
        return (A)this;
    }

    @Override
    public A setToIngress(int index, LoadBalancerIngress item) {
        LoadBalancerIngressBuilder builder = new LoadBalancerIngressBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.ingress.size()) {
            this.ingress.add(builder);
        } else {
            this.ingress.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToIngress(LoadBalancerIngress ... items) {
        for (LoadBalancerIngress item : items) {
            LoadBalancerIngressBuilder builder = new LoadBalancerIngressBuilder(item);
            this._visitables.add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToIngress(Collection<LoadBalancerIngress> items) {
        for (LoadBalancerIngress item : items) {
            LoadBalancerIngressBuilder builder = new LoadBalancerIngressBuilder(item);
            this._visitables.add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromIngress(LoadBalancerIngress ... items) {
        for (LoadBalancerIngress item : items) {
            LoadBalancerIngressBuilder builder = new LoadBalancerIngressBuilder(item);
            this._visitables.remove(builder);
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIngress(Collection<LoadBalancerIngress> items) {
        for (LoadBalancerIngress item : items) {
            LoadBalancerIngressBuilder builder = new LoadBalancerIngressBuilder(item);
            this._visitables.remove(builder);
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<LoadBalancerIngress> getIngress() {
        return LoadBalancerStatusFluentImpl.build(this.ingress);
    }

    @Override
    public List<LoadBalancerIngress> buildIngress() {
        return LoadBalancerStatusFluentImpl.build(this.ingress);
    }

    @Override
    public LoadBalancerIngress buildIngress(int index) {
        return this.ingress.get(index).build();
    }

    @Override
    public LoadBalancerIngress buildFirstIngress() {
        return this.ingress.get(0).build();
    }

    @Override
    public LoadBalancerIngress buildLastIngress() {
        return this.ingress.get(this.ingress.size() - 1).build();
    }

    @Override
    public LoadBalancerIngress buildMatchingIngress(Predicate<LoadBalancerIngressBuilder> predicate) {
        for (LoadBalancerIngressBuilder item : this.ingress) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withIngress(List<LoadBalancerIngress> ingress) {
        this._visitables.removeAll(this.ingress);
        this.ingress.clear();
        if (ingress != null) {
            for (LoadBalancerIngress item : ingress) {
                this.addToIngress(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withIngress(LoadBalancerIngress ... ingress) {
        this.ingress.clear();
        if (ingress != null) {
            for (LoadBalancerIngress item : ingress) {
                this.addToIngress(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIngress() {
        return this.ingress != null && !this.ingress.isEmpty();
    }

    @Override
    public LoadBalancerStatusFluent.IngressNested<A> addNewIngress() {
        return new IngressNestedImpl();
    }

    @Override
    public LoadBalancerStatusFluent.IngressNested<A> addNewIngressLike(LoadBalancerIngress item) {
        return new IngressNestedImpl(-1, item);
    }

    @Override
    public LoadBalancerStatusFluent.IngressNested<A> setNewIngressLike(int index, LoadBalancerIngress item) {
        return new IngressNestedImpl(index, item);
    }

    @Override
    public LoadBalancerStatusFluent.IngressNested<A> editIngress(int index) {
        if (this.ingress.size() <= index) {
            throw new RuntimeException("Can't edit ingress. Index exceeds size.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public LoadBalancerStatusFluent.IngressNested<A> editFirstIngress() {
        if (this.ingress.size() == 0) {
            throw new RuntimeException("Can't edit first ingress. The list is empty.");
        }
        return this.setNewIngressLike(0, this.buildIngress(0));
    }

    @Override
    public LoadBalancerStatusFluent.IngressNested<A> editLastIngress() {
        int index = this.ingress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ingress. The list is empty.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public LoadBalancerStatusFluent.IngressNested<A> editMatchingIngress(Predicate<LoadBalancerIngressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ingress.size(); ++i) {
            if (!predicate.apply(this.ingress.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ingress. No match found.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public A addNewIngress(String hostname, String ip) {
        return this.addToIngress(new LoadBalancerIngress(hostname, ip));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LoadBalancerStatusFluentImpl that = (LoadBalancerStatusFluentImpl)o;
        return !(this.ingress != null ? !this.ingress.equals(that.ingress) : that.ingress != null);
    }

    public class IngressNestedImpl<N>
    extends LoadBalancerIngressFluentImpl<LoadBalancerStatusFluent.IngressNested<N>>
    implements LoadBalancerStatusFluent.IngressNested<N>,
    Nested<N> {
        private final LoadBalancerIngressBuilder builder;
        private final int index;

        IngressNestedImpl(int index, LoadBalancerIngress item) {
            this.index = index;
            this.builder = new LoadBalancerIngressBuilder(this, item);
        }

        IngressNestedImpl() {
            this.index = -1;
            this.builder = new LoadBalancerIngressBuilder(this);
        }

        @Override
        public N and() {
            return (N)LoadBalancerStatusFluentImpl.this.setToIngress(this.index, this.builder.build());
        }

        @Override
        public N endIngress() {
            return this.and();
        }
    }
}

