/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_2;

import io.fabric8.kubernetes.api.builder.v2_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v2_2.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v2_2.EndpointSubset;
import io.fabric8.kubernetes.api.model.v2_2.EndpointSubsetFluent;
import io.fabric8.kubernetes.api.model.v2_2.EndpointSubsetFluentImpl;

public class EndpointSubsetBuilder
extends EndpointSubsetFluentImpl<EndpointSubsetBuilder>
implements VisitableBuilder<EndpointSubset, EndpointSubsetBuilder> {
    EndpointSubsetFluent<?> fluent;
    Boolean validationEnabled;

    public EndpointSubsetBuilder() {
        this(true);
    }

    public EndpointSubsetBuilder(Boolean validationEnabled) {
        this(new EndpointSubset(), validationEnabled);
    }

    public EndpointSubsetBuilder(EndpointSubsetFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public EndpointSubsetBuilder(EndpointSubsetFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new EndpointSubset(), validationEnabled);
    }

    public EndpointSubsetBuilder(EndpointSubsetFluent<?> fluent, EndpointSubset instance) {
        this(fluent, instance, true);
    }

    public EndpointSubsetBuilder(EndpointSubsetFluent<?> fluent, EndpointSubset instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAddresses(instance.getAddresses());
        fluent.withNotReadyAddresses(instance.getNotReadyAddresses());
        fluent.withPorts(instance.getPorts());
        this.validationEnabled = validationEnabled;
    }

    public EndpointSubsetBuilder(EndpointSubset instance) {
        this(instance, (Boolean)true);
    }

    public EndpointSubsetBuilder(EndpointSubset instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAddresses(instance.getAddresses());
        this.withNotReadyAddresses(instance.getNotReadyAddresses());
        this.withPorts(instance.getPorts());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EndpointSubset build() {
        EndpointSubset buildable = new EndpointSubset(this.fluent.getAddresses(), this.fluent.getNotReadyAddresses(), this.fluent.getPorts());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointSubsetBuilder that = (EndpointSubsetBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

