/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v1_0.rbac;

import io.fabric8.kubernetes.api.builder.v1_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v1_0.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v1_0.rbac.KubernetesRole;
import io.fabric8.kubernetes.api.model.v1_0.rbac.KubernetesRoleFluent;
import io.fabric8.kubernetes.api.model.v1_0.rbac.KubernetesRoleFluentImpl;

public class KubernetesRoleBuilder
extends KubernetesRoleFluentImpl<KubernetesRoleBuilder>
implements VisitableBuilder<KubernetesRole, KubernetesRoleBuilder> {
    KubernetesRoleFluent<?> fluent;
    Boolean validationEnabled;

    public KubernetesRoleBuilder() {
        this(true);
    }

    public KubernetesRoleBuilder(Boolean validationEnabled) {
        this(new KubernetesRole(), validationEnabled);
    }

    public KubernetesRoleBuilder(KubernetesRoleFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KubernetesRoleBuilder(KubernetesRoleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KubernetesRole(), validationEnabled);
    }

    public KubernetesRoleBuilder(KubernetesRoleFluent<?> fluent, KubernetesRole instance) {
        this(fluent, instance, true);
    }

    public KubernetesRoleBuilder(KubernetesRoleFluent<?> fluent, KubernetesRole instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRules(instance.getRules());
        this.validationEnabled = validationEnabled;
    }

    public KubernetesRoleBuilder(KubernetesRole instance) {
        this(instance, (Boolean)true);
    }

    public KubernetesRoleBuilder(KubernetesRole instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRules(instance.getRules());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public KubernetesRole build() {
        KubernetesRole buildable = new KubernetesRole(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getRules());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KubernetesRoleBuilder that = (KubernetesRoleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

