/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v1_0.batch;

import io.fabric8.kubernetes.api.builder.v1_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v1_0.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v1_0.batch.JobList;
import io.fabric8.kubernetes.api.model.v1_0.batch.JobListFluent;
import io.fabric8.kubernetes.api.model.v1_0.batch.JobListFluentImpl;

public class JobListBuilder
extends JobListFluentImpl<JobListBuilder>
implements VisitableBuilder<JobList, JobListBuilder> {
    JobListFluent<?> fluent;
    Boolean validationEnabled;

    public JobListBuilder() {
        this(true);
    }

    public JobListBuilder(Boolean validationEnabled) {
        this(new JobList(), validationEnabled);
    }

    public JobListBuilder(JobListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public JobListBuilder(JobListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new JobList(), validationEnabled);
    }

    public JobListBuilder(JobListFluent<?> fluent, JobList instance) {
        this(fluent, instance, true);
    }

    public JobListBuilder(JobListFluent<?> fluent, JobList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public JobListBuilder(JobList instance) {
        this(instance, (Boolean)true);
    }

    public JobListBuilder(JobList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public JobList build() {
        JobList buildable = new JobList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JobListBuilder that = (JobListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

