/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v1_0;

import io.fabric8.kubernetes.api.builder.v1_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v1_0.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v1_0.ObjectReference;
import io.fabric8.kubernetes.api.model.v1_0.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.v1_0.ObjectReferenceFluentImpl;

public class ObjectReferenceBuilder
extends ObjectReferenceFluentImpl<ObjectReferenceBuilder>
implements VisitableBuilder<ObjectReference, ObjectReferenceBuilder> {
    ObjectReferenceFluent<?> fluent;
    Boolean validationEnabled;

    public ObjectReferenceBuilder() {
        this(true);
    }

    public ObjectReferenceBuilder(Boolean validationEnabled) {
        this(new ObjectReference(), validationEnabled);
    }

    public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ObjectReference(), validationEnabled);
    }

    public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent, ObjectReference instance) {
        this(fluent, instance, true);
    }

    public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent, ObjectReference instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withFieldPath(instance.getFieldPath());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        fluent.withResourceVersion(instance.getResourceVersion());
        fluent.withUid(instance.getUid());
        this.validationEnabled = validationEnabled;
    }

    public ObjectReferenceBuilder(ObjectReference instance) {
        this(instance, (Boolean)true);
    }

    public ObjectReferenceBuilder(ObjectReference instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withFieldPath(instance.getFieldPath());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withResourceVersion(instance.getResourceVersion());
        this.withUid(instance.getUid());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ObjectReference build() {
        ObjectReference buildable = new ObjectReference(this.fluent.getApiVersion(), this.fluent.getFieldPath(), this.fluent.getKind(), this.fluent.getName(), this.fluent.getNamespace(), this.fluent.getResourceVersion(), this.fluent.getUid());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectReferenceBuilder that = (ObjectReferenceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

