/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v1_0;

import io.fabric8.kubernetes.api.builder.v1_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v1_0.Nested;
import io.fabric8.kubernetes.api.model.v1_0.Node;
import io.fabric8.kubernetes.api.model.v1_0.NodeFluent;
import io.fabric8.kubernetes.api.model.v1_0.NodeSpec;
import io.fabric8.kubernetes.api.model.v1_0.NodeSpecBuilder;
import io.fabric8.kubernetes.api.model.v1_0.NodeSpecFluentImpl;
import io.fabric8.kubernetes.api.model.v1_0.NodeStatus;
import io.fabric8.kubernetes.api.model.v1_0.NodeStatusBuilder;
import io.fabric8.kubernetes.api.model.v1_0.NodeStatusFluentImpl;
import io.fabric8.kubernetes.api.model.v1_0.ObjectMeta;
import io.fabric8.kubernetes.api.model.v1_0.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v1_0.ObjectMetaFluentImpl;

public class NodeFluentImpl<A extends NodeFluent<A>>
extends BaseFluent<A>
implements NodeFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private NodeSpecBuilder spec;
    private NodeStatusBuilder status;

    public NodeFluentImpl() {
    }

    public NodeFluentImpl(Node instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public NodeFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public NodeFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public NodeFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public NodeFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public NodeFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public NodeSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public NodeSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(NodeSpec spec) {
        this._visitables.remove(this.spec);
        if (spec != null) {
            this.spec = new NodeSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public NodeFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public NodeFluent.SpecNested<A> withNewSpecLike(NodeSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public NodeFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public NodeFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new NodeSpecBuilder().build());
    }

    @Override
    public NodeFluent.SpecNested<A> editOrNewSpecLike(NodeSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public NodeStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public NodeStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(NodeStatus status) {
        this._visitables.remove(this.status);
        if (status != null) {
            this.status = new NodeStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public NodeFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public NodeFluent.StatusNested<A> withNewStatusLike(NodeStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public NodeFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public NodeFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new NodeStatusBuilder().build());
    }

    @Override
    public NodeFluent.StatusNested<A> editOrNewStatusLike(NodeStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeFluentImpl that = (NodeFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends NodeStatusFluentImpl<NodeFluent.StatusNested<N>>
    implements NodeFluent.StatusNested<N>,
    Nested<N> {
        private final NodeStatusBuilder builder;

        StatusNestedImpl(NodeStatus item) {
            this.builder = new NodeStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new NodeStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)NodeFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends NodeSpecFluentImpl<NodeFluent.SpecNested<N>>
    implements NodeFluent.SpecNested<N>,
    Nested<N> {
        private final NodeSpecBuilder builder;

        SpecNestedImpl(NodeSpec item) {
            this.builder = new NodeSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new NodeSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)NodeFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<NodeFluent.MetadataNested<N>>
    implements NodeFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)NodeFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

