/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v1_0;

import io.fabric8.kubernetes.api.builder.v1_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v1_0.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v1_0.AuthProviderConfig;
import io.fabric8.kubernetes.api.model.v1_0.AuthProviderConfigFluent;
import io.fabric8.kubernetes.api.model.v1_0.AuthProviderConfigFluentImpl;

public class AuthProviderConfigBuilder
extends AuthProviderConfigFluentImpl<AuthProviderConfigBuilder>
implements VisitableBuilder<AuthProviderConfig, AuthProviderConfigBuilder> {
    AuthProviderConfigFluent<?> fluent;
    Boolean validationEnabled;

    public AuthProviderConfigBuilder() {
        this(true);
    }

    public AuthProviderConfigBuilder(Boolean validationEnabled) {
        this(new AuthProviderConfig(), validationEnabled);
    }

    public AuthProviderConfigBuilder(AuthProviderConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public AuthProviderConfigBuilder(AuthProviderConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new AuthProviderConfig(), validationEnabled);
    }

    public AuthProviderConfigBuilder(AuthProviderConfigFluent<?> fluent, AuthProviderConfig instance) {
        this(fluent, instance, true);
    }

    public AuthProviderConfigBuilder(AuthProviderConfigFluent<?> fluent, AuthProviderConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withConfig(instance.getConfig());
        fluent.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public AuthProviderConfigBuilder(AuthProviderConfig instance) {
        this(instance, (Boolean)true);
    }

    public AuthProviderConfigBuilder(AuthProviderConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withConfig(instance.getConfig());
        this.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public AuthProviderConfig build() {
        AuthProviderConfig buildable = new AuthProviderConfig(this.fluent.getConfig(), this.fluent.getName());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthProviderConfigBuilder that = (AuthProviderConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

