/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v1_0;

import io.fabric8.kubernetes.api.builder.v1_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v1_0.VisitableBuilder;
import io.fabric8.openshift.api.model.v1_0.PolicyBinding;
import io.fabric8.openshift.api.model.v1_0.PolicyBindingFluent;
import io.fabric8.openshift.api.model.v1_0.PolicyBindingFluentImpl;

public class PolicyBindingBuilder
extends PolicyBindingFluentImpl<PolicyBindingBuilder>
implements VisitableBuilder<PolicyBinding, PolicyBindingBuilder> {
    PolicyBindingFluent<?> fluent;
    Boolean validationEnabled;

    public PolicyBindingBuilder() {
        this(true);
    }

    public PolicyBindingBuilder(Boolean validationEnabled) {
        this(new PolicyBinding(), validationEnabled);
    }

    public PolicyBindingBuilder(PolicyBindingFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PolicyBindingBuilder(PolicyBindingFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PolicyBinding(), validationEnabled);
    }

    public PolicyBindingBuilder(PolicyBindingFluent<?> fluent, PolicyBinding instance) {
        this(fluent, instance, true);
    }

    public PolicyBindingBuilder(PolicyBindingFluent<?> fluent, PolicyBinding instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withLastModified(instance.getLastModified());
        fluent.withMetadata(instance.getMetadata());
        fluent.withPolicyRef(instance.getPolicyRef());
        fluent.withRoleBindings(instance.getRoleBindings());
        this.validationEnabled = validationEnabled;
    }

    public PolicyBindingBuilder(PolicyBinding instance) {
        this(instance, (Boolean)true);
    }

    public PolicyBindingBuilder(PolicyBinding instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withLastModified(instance.getLastModified());
        this.withMetadata(instance.getMetadata());
        this.withPolicyRef(instance.getPolicyRef());
        this.withRoleBindings(instance.getRoleBindings());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public PolicyBinding build() {
        PolicyBinding buildable = new PolicyBinding(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getLastModified(), this.fluent.getMetadata(), this.fluent.getPolicyRef(), this.fluent.getRoleBindings());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PolicyBindingBuilder that = (PolicyBindingBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

