/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v1_0.extensions;

import io.fabric8.kubernetes.api.builder.v1_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v1_0.Nested;
import io.fabric8.kubernetes.api.model.v1_0.extensions.DeploymentRollback;
import io.fabric8.kubernetes.api.model.v1_0.extensions.DeploymentRollbackFluent;
import io.fabric8.kubernetes.api.model.v1_0.extensions.RollbackConfig;
import io.fabric8.kubernetes.api.model.v1_0.extensions.RollbackConfigBuilder;
import io.fabric8.kubernetes.api.model.v1_0.extensions.RollbackConfigFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;

public class DeploymentRollbackFluentImpl<A extends DeploymentRollbackFluent<A>>
extends BaseFluent<A>
implements DeploymentRollbackFluent<A> {
    private String apiVersion;
    private String kind;
    private String name;
    private RollbackConfigBuilder rollbackTo;
    private Map<String, String> updatedAnnotations;

    public DeploymentRollbackFluentImpl() {
    }

    public DeploymentRollbackFluentImpl(DeploymentRollback instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withRollbackTo(instance.getRollbackTo());
        this.withUpdatedAnnotations(instance.getUpdatedAnnotations());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public RollbackConfig getRollbackTo() {
        return this.rollbackTo != null ? this.rollbackTo.build() : null;
    }

    @Override
    public RollbackConfig buildRollbackTo() {
        return this.rollbackTo != null ? this.rollbackTo.build() : null;
    }

    @Override
    public A withRollbackTo(RollbackConfig rollbackTo) {
        this._visitables.remove(this.rollbackTo);
        if (rollbackTo != null) {
            this.rollbackTo = new RollbackConfigBuilder(rollbackTo);
            this._visitables.add(this.rollbackTo);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRollbackTo() {
        return this.rollbackTo != null;
    }

    @Override
    public A withNewRollbackTo(Long revision) {
        return this.withRollbackTo(new RollbackConfig(revision));
    }

    @Override
    public DeploymentRollbackFluent.RollbackToNested<A> withNewRollbackTo() {
        return new RollbackToNestedImpl();
    }

    @Override
    public DeploymentRollbackFluent.RollbackToNested<A> withNewRollbackToLike(RollbackConfig item) {
        return new RollbackToNestedImpl(item);
    }

    @Override
    public DeploymentRollbackFluent.RollbackToNested<A> editRollbackTo() {
        return this.withNewRollbackToLike(this.getRollbackTo());
    }

    @Override
    public DeploymentRollbackFluent.RollbackToNested<A> editOrNewRollbackTo() {
        return this.withNewRollbackToLike(this.getRollbackTo() != null ? this.getRollbackTo() : new RollbackConfigBuilder().build());
    }

    @Override
    public DeploymentRollbackFluent.RollbackToNested<A> editOrNewRollbackToLike(RollbackConfig item) {
        return this.withNewRollbackToLike(this.getRollbackTo() != null ? this.getRollbackTo() : item);
    }

    @Override
    public A addToUpdatedAnnotations(String key, String value) {
        if (key != null && value != null) {
            this.updatedAnnotations.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToUpdatedAnnotations(Map<String, String> map) {
        if (map != null) {
            this.updatedAnnotations.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromUpdatedAnnotations(String key) {
        if (key != null && this.updatedAnnotations != null) {
            this.updatedAnnotations.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromUpdatedAnnotations(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.updatedAnnotations == null) continue;
                this.updatedAnnotations.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getUpdatedAnnotations() {
        return this.updatedAnnotations;
    }

    @Override
    public A withUpdatedAnnotations(Map<String, String> updatedAnnotations) {
        if (this.updatedAnnotations == null) {
            this.updatedAnnotations = new LinkedHashMap<String, String>();
        } else {
            this.updatedAnnotations.clear();
        }
        if (updatedAnnotations != null) {
            this.updatedAnnotations.putAll(updatedAnnotations);
        }
        return (A)this;
    }

    @Override
    public Boolean hasUpdatedAnnotations() {
        return this.updatedAnnotations != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentRollbackFluentImpl that = (DeploymentRollbackFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.rollbackTo != null ? !this.rollbackTo.equals(that.rollbackTo) : that.rollbackTo != null) {
            return false;
        }
        return !(this.updatedAnnotations != null ? !this.updatedAnnotations.equals(that.updatedAnnotations) : that.updatedAnnotations != null);
    }

    public class RollbackToNestedImpl<N>
    extends RollbackConfigFluentImpl<DeploymentRollbackFluent.RollbackToNested<N>>
    implements DeploymentRollbackFluent.RollbackToNested<N>,
    Nested<N> {
        private final RollbackConfigBuilder builder;

        RollbackToNestedImpl(RollbackConfig item) {
            this.builder = new RollbackConfigBuilder(this, item);
        }

        RollbackToNestedImpl() {
            this.builder = new RollbackConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentRollbackFluentImpl.this.withRollbackTo(this.builder.build());
        }

        @Override
        public N endRollbackTo() {
            return this.and();
        }
    }
}

