/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v1_0;

import io.fabric8.kubernetes.api.builder.v1_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v1_0.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v1_0.WatchEvent;
import io.fabric8.kubernetes.api.model.v1_0.WatchEventFluent;
import io.fabric8.kubernetes.api.model.v1_0.WatchEventFluentImpl;

public class WatchEventBuilder
extends WatchEventFluentImpl<WatchEventBuilder>
implements VisitableBuilder<WatchEvent, WatchEventBuilder> {
    WatchEventFluent<?> fluent;
    Boolean validationEnabled;

    public WatchEventBuilder() {
        this(true);
    }

    public WatchEventBuilder(Boolean validationEnabled) {
        this(new WatchEvent(), validationEnabled);
    }

    public WatchEventBuilder(WatchEventFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public WatchEventBuilder(WatchEventFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new WatchEvent(), validationEnabled);
    }

    public WatchEventBuilder(WatchEventFluent<?> fluent, WatchEvent instance) {
        this(fluent, instance, true);
    }

    public WatchEventBuilder(WatchEventFluent<?> fluent, WatchEvent instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withObject(instance.getObject());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public WatchEventBuilder(WatchEvent instance) {
        this(instance, (Boolean)true);
    }

    public WatchEventBuilder(WatchEvent instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withObject(instance.getObject());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public WatchEvent build() {
        WatchEvent buildable = new WatchEvent(this.fluent.getObject(), this.fluent.getType());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WatchEventBuilder that = (WatchEventBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

