/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v1_0;

import io.fabric8.kubernetes.api.builder.v1_0.BaseFluent;
import io.fabric8.kubernetes.api.model.v1_0.Quantity;
import io.fabric8.kubernetes.api.model.v1_0.ResourceRequirements;
import io.fabric8.kubernetes.api.model.v1_0.ResourceRequirementsFluent;
import java.util.LinkedHashMap;
import java.util.Map;

public class ResourceRequirementsFluentImpl<A extends ResourceRequirementsFluent<A>>
extends BaseFluent<A>
implements ResourceRequirementsFluent<A> {
    private Map<String, Quantity> limits;
    private Map<String, Quantity> requests;

    public ResourceRequirementsFluentImpl() {
    }

    public ResourceRequirementsFluentImpl(ResourceRequirements instance) {
        this.withLimits(instance.getLimits());
        this.withRequests(instance.getRequests());
    }

    @Override
    public A addToLimits(String key, Quantity value) {
        if (key != null && value != null) {
            this.limits.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLimits(Map<String, Quantity> map) {
        if (map != null) {
            this.limits.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLimits(String key) {
        if (key != null && this.limits != null) {
            this.limits.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLimits(Map<String, Quantity> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.limits == null) continue;
                this.limits.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getLimits() {
        return this.limits;
    }

    @Override
    public A withLimits(Map<String, Quantity> limits) {
        if (this.limits == null) {
            this.limits = new LinkedHashMap<String, Quantity>();
        } else {
            this.limits.clear();
        }
        if (limits != null) {
            this.limits.putAll(limits);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLimits() {
        return this.limits != null;
    }

    @Override
    public A addToRequests(String key, Quantity value) {
        if (key != null && value != null) {
            this.requests.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToRequests(Map<String, Quantity> map) {
        if (map != null) {
            this.requests.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromRequests(String key) {
        if (key != null && this.requests != null) {
            this.requests.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromRequests(Map<String, Quantity> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.requests == null) continue;
                this.requests.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getRequests() {
        return this.requests;
    }

    @Override
    public A withRequests(Map<String, Quantity> requests) {
        if (this.requests == null) {
            this.requests = new LinkedHashMap<String, Quantity>();
        } else {
            this.requests.clear();
        }
        if (requests != null) {
            this.requests.putAll(requests);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRequests() {
        return this.requests != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceRequirementsFluentImpl that = (ResourceRequirementsFluentImpl)o;
        if (this.limits != null ? !this.limits.equals(that.limits) : that.limits != null) {
            return false;
        }
        return !(this.requests != null ? !this.requests.equals(that.requests) : that.requests != null);
    }
}

