/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v1_0;

import io.fabric8.kubernetes.api.builder.v1_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v1_0.Predicate;
import io.fabric8.kubernetes.api.model.v1_0.ExecAction;
import io.fabric8.kubernetes.api.model.v1_0.ExecActionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExecActionFluentImpl<A extends ExecActionFluent<A>>
extends BaseFluent<A>
implements ExecActionFluent<A> {
    private List<String> command;

    public ExecActionFluentImpl() {
    }

    public ExecActionFluentImpl(ExecAction instance) {
        this.withCommand(instance.getCommand());
    }

    @Override
    public A addToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCommand(int index, String item) {
        this.command.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCommand(String ... items) {
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCommand(Collection<String> items) {
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCommand(String ... items) {
        for (String item : items) {
            if (this.command == null) continue;
            this.command.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCommand(Collection<String> items) {
        for (String item : items) {
            if (this.command == null) continue;
            this.command.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCommand() {
        return this.command;
    }

    @Override
    public String getCommand(int index) {
        return this.command.get(index);
    }

    @Override
    public String getFirstCommand() {
        return this.command.get(0);
    }

    @Override
    public String getLastCommand() {
        return this.command.get(this.command.size() - 1);
    }

    @Override
    public String getMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withCommand(List<String> command) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        } else {
            this._visitables.removeAll(this.command);
            this.command.clear();
        }
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withCommand(String ... command) {
        this.command.clear();
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCommand() {
        return this.command != null && !this.command.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExecActionFluentImpl that = (ExecActionFluentImpl)o;
        return !(this.command != null ? !this.command.equals(that.command) : that.command != null);
    }
}

