/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeDriver;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeDriverFluent;
import io.fabric8.kubernetes.api.model.storage.v1beta1.VolumeNodeResources;
import io.fabric8.kubernetes.api.model.storage.v1beta1.VolumeNodeResourcesBuilder;
import io.fabric8.kubernetes.api.model.storage.v1beta1.VolumeNodeResourcesFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CSINodeDriverFluentImpl<A extends CSINodeDriverFluent<A>>
extends BaseFluent<A>
implements CSINodeDriverFluent<A> {
    private VolumeNodeResourcesBuilder allocatable;
    private String name;
    private String nodeID;
    private List<String> topologyKeys = new ArrayList<String>();

    public CSINodeDriverFluentImpl() {
    }

    public CSINodeDriverFluentImpl(CSINodeDriver instance) {
        this.withAllocatable(instance.getAllocatable());
        this.withName(instance.getName());
        this.withNodeID(instance.getNodeID());
        this.withTopologyKeys(instance.getTopologyKeys());
    }

    @Override
    @Deprecated
    public VolumeNodeResources getAllocatable() {
        return this.allocatable != null ? this.allocatable.build() : null;
    }

    @Override
    public VolumeNodeResources buildAllocatable() {
        return this.allocatable != null ? this.allocatable.build() : null;
    }

    @Override
    public A withAllocatable(VolumeNodeResources allocatable) {
        this._visitables.get("allocatable").remove(this.allocatable);
        if (allocatable != null) {
            this.allocatable = new VolumeNodeResourcesBuilder(allocatable);
            this._visitables.get("allocatable").add(this.allocatable);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllocatable() {
        return this.allocatable != null;
    }

    @Override
    public A withNewAllocatable(Integer count) {
        return this.withAllocatable(new VolumeNodeResources(count));
    }

    @Override
    public CSINodeDriverFluent.AllocatableNested<A> withNewAllocatable() {
        return new AllocatableNestedImpl();
    }

    @Override
    public CSINodeDriverFluent.AllocatableNested<A> withNewAllocatableLike(VolumeNodeResources item) {
        return new AllocatableNestedImpl(item);
    }

    @Override
    public CSINodeDriverFluent.AllocatableNested<A> editAllocatable() {
        return this.withNewAllocatableLike(this.getAllocatable());
    }

    @Override
    public CSINodeDriverFluent.AllocatableNested<A> editOrNewAllocatable() {
        return this.withNewAllocatableLike(this.getAllocatable() != null ? this.getAllocatable() : new VolumeNodeResourcesBuilder().build());
    }

    @Override
    public CSINodeDriverFluent.AllocatableNested<A> editOrNewAllocatableLike(VolumeNodeResources item) {
        return this.withNewAllocatableLike(this.getAllocatable() != null ? this.getAllocatable() : item);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A withNewName(String arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuilder arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuffer arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    @Override
    public A withNodeID(String nodeID) {
        this.nodeID = nodeID;
        return (A)this;
    }

    @Override
    public Boolean hasNodeID() {
        return this.nodeID != null;
    }

    @Override
    public A withNewNodeID(String arg1) {
        return this.withNodeID(new String(arg1));
    }

    @Override
    public A withNewNodeID(StringBuilder arg1) {
        return this.withNodeID(new String(arg1));
    }

    @Override
    public A withNewNodeID(StringBuffer arg1) {
        return this.withNodeID(new String(arg1));
    }

    @Override
    public A addToTopologyKeys(int index, String item) {
        if (this.topologyKeys == null) {
            this.topologyKeys = new ArrayList<String>();
        }
        this.topologyKeys.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTopologyKeys(int index, String item) {
        if (this.topologyKeys == null) {
            this.topologyKeys = new ArrayList<String>();
        }
        this.topologyKeys.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTopologyKeys(String ... items) {
        if (this.topologyKeys == null) {
            this.topologyKeys = new ArrayList<String>();
        }
        for (String item : items) {
            this.topologyKeys.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTopologyKeys(Collection<String> items) {
        if (this.topologyKeys == null) {
            this.topologyKeys = new ArrayList<String>();
        }
        for (String item : items) {
            this.topologyKeys.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTopologyKeys(String ... items) {
        for (String item : items) {
            if (this.topologyKeys == null) continue;
            this.topologyKeys.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTopologyKeys(Collection<String> items) {
        for (String item : items) {
            if (this.topologyKeys == null) continue;
            this.topologyKeys.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getTopologyKeys() {
        return this.topologyKeys;
    }

    @Override
    public String getTopologyKey(int index) {
        return this.topologyKeys.get(index);
    }

    @Override
    public String getFirstTopologyKey() {
        return this.topologyKeys.get(0);
    }

    @Override
    public String getLastTopologyKey() {
        return this.topologyKeys.get(this.topologyKeys.size() - 1);
    }

    @Override
    public String getMatchingTopologyKey(Predicate<String> predicate) {
        for (String item : this.topologyKeys) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTopologyKey(Predicate<String> predicate) {
        for (String item : this.topologyKeys) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTopologyKeys(List<String> topologyKeys) {
        if (this.topologyKeys != null) {
            this._visitables.get("topologyKeys").removeAll(this.topologyKeys);
        }
        if (topologyKeys != null) {
            this.topologyKeys = new ArrayList<String>();
            for (String item : topologyKeys) {
                this.addToTopologyKeys(item);
            }
        } else {
            this.topologyKeys = null;
        }
        return (A)this;
    }

    @Override
    public A withTopologyKeys(String ... topologyKeys) {
        if (this.topologyKeys != null) {
            this.topologyKeys.clear();
        }
        if (topologyKeys != null) {
            for (String item : topologyKeys) {
                this.addToTopologyKeys(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTopologyKeys() {
        return this.topologyKeys != null && !this.topologyKeys.isEmpty();
    }

    @Override
    public A addNewTopologyKey(String arg1) {
        return this.addToTopologyKeys(new String(arg1));
    }

    @Override
    public A addNewTopologyKey(StringBuilder arg1) {
        return this.addToTopologyKeys(new String(arg1));
    }

    @Override
    public A addNewTopologyKey(StringBuffer arg1) {
        return this.addToTopologyKeys(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CSINodeDriverFluentImpl that = (CSINodeDriverFluentImpl)o;
        if (this.allocatable != null ? !this.allocatable.equals(that.allocatable) : that.allocatable != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.nodeID != null ? !this.nodeID.equals(that.nodeID) : that.nodeID != null) {
            return false;
        }
        return !(this.topologyKeys != null ? !this.topologyKeys.equals(that.topologyKeys) : that.topologyKeys != null);
    }

    public class AllocatableNestedImpl<N>
    extends VolumeNodeResourcesFluentImpl<CSINodeDriverFluent.AllocatableNested<N>>
    implements CSINodeDriverFluent.AllocatableNested<N>,
    Nested<N> {
        private final VolumeNodeResourcesBuilder builder;

        AllocatableNestedImpl(VolumeNodeResources item) {
            this.builder = new VolumeNodeResourcesBuilder(this, item);
        }

        AllocatableNestedImpl() {
            this.builder = new VolumeNodeResourcesBuilder(this);
        }

        @Override
        public N and() {
            return (N)CSINodeDriverFluentImpl.this.withAllocatable(this.builder.build());
        }

        @Override
        public N endAllocatable() {
            return this.and();
        }
    }
}

