package io.fabric8.kubernetes.api.model;

import java.lang.Integer;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class HPAScalingPolicyFluentImpl<A extends HPAScalingPolicyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements HPAScalingPolicyFluent<A>{

    private Integer periodSeconds;
    private String type;
    private Integer value;

    public HPAScalingPolicyFluentImpl(){
    }
    public HPAScalingPolicyFluentImpl(HPAScalingPolicy instance){
            this.withPeriodSeconds(instance.getPeriodSeconds()); 
            this.withType(instance.getType()); 
            this.withValue(instance.getValue()); 
    }

    public Integer getPeriodSeconds(){
            return this.periodSeconds;
    }

    public A withPeriodSeconds(Integer periodSeconds){
            this.periodSeconds=periodSeconds; return (A) this;
    }

    public Boolean hasPeriodSeconds(){
            return this.periodSeconds != null;
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type != null;
    }

    public A withNewType(String arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1){
            return (A)withType(new String(arg1));
    }

    public Integer getValue(){
            return this.value;
    }

    public A withValue(Integer value){
            this.value=value; return (A) this;
    }

    public Boolean hasValue(){
            return this.value != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            HPAScalingPolicyFluentImpl that = (HPAScalingPolicyFluentImpl) o;
            if (periodSeconds != null ? !periodSeconds.equals(that.periodSeconds) :that.periodSeconds != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            if (value != null ? !value.equals(that.value) :that.value != null) return false;
            return true;
    }




}
