package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ComponentOverrideBuilder extends ComponentOverrideFluentImpl<ComponentOverrideBuilder> implements VisitableBuilder<ComponentOverride,ComponentOverrideBuilder>{

    ComponentOverrideFluent<?> fluent;
    Boolean validationEnabled;

    public ComponentOverrideBuilder(){
            this(true);
    }
    public ComponentOverrideBuilder(Boolean validationEnabled){
            this(new ComponentOverride(), validationEnabled);
    }
    public ComponentOverrideBuilder(ComponentOverrideFluent<?> fluent){
            this(fluent, true);
    }
    public ComponentOverrideBuilder(ComponentOverrideFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ComponentOverride(), validationEnabled);
    }
    public ComponentOverrideBuilder(ComponentOverrideFluent<?> fluent,ComponentOverride instance){
            this(fluent, instance, true);
    }
    public ComponentOverrideBuilder(ComponentOverrideFluent<?> fluent,ComponentOverride instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withGroup(instance.getGroup()); 
            fluent.withKind(instance.getKind()); 
            fluent.withName(instance.getName()); 
            fluent.withNamespace(instance.getNamespace()); 
            fluent.withUnmanaged(instance.getUnmanaged()); 
            this.validationEnabled = validationEnabled; 
    }
    public ComponentOverrideBuilder(ComponentOverride instance){
            this(instance,true);
    }
    public ComponentOverrideBuilder(ComponentOverride instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withGroup(instance.getGroup()); 
            this.withKind(instance.getKind()); 
            this.withName(instance.getName()); 
            this.withNamespace(instance.getNamespace()); 
            this.withUnmanaged(instance.getUnmanaged()); 
            this.validationEnabled = validationEnabled; 
    }

    public ComponentOverride build(){
            ComponentOverride buildable = new ComponentOverride(fluent.getGroup(),fluent.getKind(),fluent.getName(),fluent.getNamespace(),fluent.isUnmanaged());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ComponentOverrideBuilder that = (ComponentOverrideBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
