package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HorizontalPodAutoscalerBehaviorBuilder extends HorizontalPodAutoscalerBehaviorFluentImpl<HorizontalPodAutoscalerBehaviorBuilder> implements VisitableBuilder<HorizontalPodAutoscalerBehavior,HorizontalPodAutoscalerBehaviorBuilder>{

    HorizontalPodAutoscalerBehaviorFluent<?> fluent;
    Boolean validationEnabled;

    public HorizontalPodAutoscalerBehaviorBuilder(){
            this(true);
    }
    public HorizontalPodAutoscalerBehaviorBuilder(Boolean validationEnabled){
            this(new HorizontalPodAutoscalerBehavior(), validationEnabled);
    }
    public HorizontalPodAutoscalerBehaviorBuilder(HorizontalPodAutoscalerBehaviorFluent<?> fluent){
            this(fluent, true);
    }
    public HorizontalPodAutoscalerBehaviorBuilder(HorizontalPodAutoscalerBehaviorFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HorizontalPodAutoscalerBehavior(), validationEnabled);
    }
    public HorizontalPodAutoscalerBehaviorBuilder(HorizontalPodAutoscalerBehaviorFluent<?> fluent,HorizontalPodAutoscalerBehavior instance){
            this(fluent, instance, true);
    }
    public HorizontalPodAutoscalerBehaviorBuilder(HorizontalPodAutoscalerBehaviorFluent<?> fluent,HorizontalPodAutoscalerBehavior instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withScaleDown(instance.getScaleDown()); 
            fluent.withScaleUp(instance.getScaleUp()); 
            this.validationEnabled = validationEnabled; 
    }
    public HorizontalPodAutoscalerBehaviorBuilder(HorizontalPodAutoscalerBehavior instance){
            this(instance,true);
    }
    public HorizontalPodAutoscalerBehaviorBuilder(HorizontalPodAutoscalerBehavior instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withScaleDown(instance.getScaleDown()); 
            this.withScaleUp(instance.getScaleUp()); 
            this.validationEnabled = validationEnabled; 
    }

    public HorizontalPodAutoscalerBehavior build(){
            HorizontalPodAutoscalerBehavior buildable = new HorizontalPodAutoscalerBehavior(fluent.getScaleDown(),fluent.getScaleUp());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HorizontalPodAutoscalerBehaviorBuilder that = (HorizontalPodAutoscalerBehaviorBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
