package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HPAScalingPolicyBuilder extends HPAScalingPolicyFluentImpl<HPAScalingPolicyBuilder> implements VisitableBuilder<HPAScalingPolicy,HPAScalingPolicyBuilder>{

    HPAScalingPolicyFluent<?> fluent;
    Boolean validationEnabled;

    public HPAScalingPolicyBuilder(){
            this(true);
    }
    public HPAScalingPolicyBuilder(Boolean validationEnabled){
            this(new HPAScalingPolicy(), validationEnabled);
    }
    public HPAScalingPolicyBuilder(HPAScalingPolicyFluent<?> fluent){
            this(fluent, true);
    }
    public HPAScalingPolicyBuilder(HPAScalingPolicyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HPAScalingPolicy(), validationEnabled);
    }
    public HPAScalingPolicyBuilder(HPAScalingPolicyFluent<?> fluent,HPAScalingPolicy instance){
            this(fluent, instance, true);
    }
    public HPAScalingPolicyBuilder(HPAScalingPolicyFluent<?> fluent,HPAScalingPolicy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPeriodSeconds(instance.getPeriodSeconds()); 
            fluent.withType(instance.getType()); 
            fluent.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public HPAScalingPolicyBuilder(HPAScalingPolicy instance){
            this(instance,true);
    }
    public HPAScalingPolicyBuilder(HPAScalingPolicy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPeriodSeconds(instance.getPeriodSeconds()); 
            this.withType(instance.getType()); 
            this.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }

    public HPAScalingPolicy build(){
            HPAScalingPolicy buildable = new HPAScalingPolicy(fluent.getPeriodSeconds(),fluent.getType(),fluent.getValue());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HPAScalingPolicyBuilder that = (HPAScalingPolicyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
