package io.fabric8.kubernetes.api.model.discovery;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DiscoveryEndpointPortBuilder extends DiscoveryEndpointPortFluentImpl<DiscoveryEndpointPortBuilder> implements VisitableBuilder<DiscoveryEndpointPort,DiscoveryEndpointPortBuilder>{

    DiscoveryEndpointPortFluent<?> fluent;
    Boolean validationEnabled;

    public DiscoveryEndpointPortBuilder(){
            this(true);
    }
    public DiscoveryEndpointPortBuilder(Boolean validationEnabled){
            this(new DiscoveryEndpointPort(), validationEnabled);
    }
    public DiscoveryEndpointPortBuilder(DiscoveryEndpointPortFluent<?> fluent){
            this(fluent, true);
    }
    public DiscoveryEndpointPortBuilder(DiscoveryEndpointPortFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DiscoveryEndpointPort(), validationEnabled);
    }
    public DiscoveryEndpointPortBuilder(DiscoveryEndpointPortFluent<?> fluent,DiscoveryEndpointPort instance){
            this(fluent, instance, true);
    }
    public DiscoveryEndpointPortBuilder(DiscoveryEndpointPortFluent<?> fluent,DiscoveryEndpointPort instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAppProtocol(instance.getAppProtocol()); 
            fluent.withName(instance.getName()); 
            fluent.withPort(instance.getPort()); 
            fluent.withProtocol(instance.getProtocol()); 
            this.validationEnabled = validationEnabled; 
    }
    public DiscoveryEndpointPortBuilder(DiscoveryEndpointPort instance){
            this(instance,true);
    }
    public DiscoveryEndpointPortBuilder(DiscoveryEndpointPort instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAppProtocol(instance.getAppProtocol()); 
            this.withName(instance.getName()); 
            this.withPort(instance.getPort()); 
            this.withProtocol(instance.getProtocol()); 
            this.validationEnabled = validationEnabled; 
    }

    public DiscoveryEndpointPort build(){
            DiscoveryEndpointPort buildable = new DiscoveryEndpointPort(fluent.getAppProtocol(),fluent.getName(),fluent.getPort(),fluent.getProtocol());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DiscoveryEndpointPortBuilder that = (DiscoveryEndpointPortBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
