package io.fabric8.kubernetes.api.model.discovery;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EndpointSliceBuilder extends EndpointSliceFluentImpl<EndpointSliceBuilder> implements VisitableBuilder<EndpointSlice,EndpointSliceBuilder>{

    EndpointSliceFluent<?> fluent;
    Boolean validationEnabled;

    public EndpointSliceBuilder(){
            this(true);
    }
    public EndpointSliceBuilder(Boolean validationEnabled){
            this(new EndpointSlice(), validationEnabled);
    }
    public EndpointSliceBuilder(EndpointSliceFluent<?> fluent){
            this(fluent, true);
    }
    public EndpointSliceBuilder(EndpointSliceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new EndpointSlice(), validationEnabled);
    }
    public EndpointSliceBuilder(EndpointSliceFluent<?> fluent,EndpointSlice instance){
            this(fluent, instance, true);
    }
    public EndpointSliceBuilder(EndpointSliceFluent<?> fluent,EndpointSlice instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAddressType(instance.getAddressType()); 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withEndpoints(instance.getEndpoints()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withPorts(instance.getPorts()); 
            this.validationEnabled = validationEnabled; 
    }
    public EndpointSliceBuilder(EndpointSlice instance){
            this(instance,true);
    }
    public EndpointSliceBuilder(EndpointSlice instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAddressType(instance.getAddressType()); 
            this.withApiVersion(instance.getApiVersion()); 
            this.withEndpoints(instance.getEndpoints()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withPorts(instance.getPorts()); 
            this.validationEnabled = validationEnabled; 
    }

    public EndpointSlice build(){
            EndpointSlice buildable = new EndpointSlice(fluent.getAddressType(),fluent.getApiVersion(),fluent.getEndpoints(),fluent.getKind(),fluent.getMetadata(),fluent.getPorts());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EndpointSliceBuilder that = (EndpointSliceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
