package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.DurationFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Long;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.model.DurationBuilder;

public interface NodeMetricsFluent<A extends NodeMetricsFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public NodeMetricsFluent.MetadataNested<A> withNewMetadata();
    public NodeMetricsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public NodeMetricsFluent.MetadataNested<A> editMetadata();
    public NodeMetricsFluent.MetadataNested<A> editOrNewMetadata();
    public NodeMetricsFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public String getTimestamp();
    public A withTimestamp(String timestamp);
    public Boolean hasTimestamp();
    public A withNewTimestamp(String arg1);
    public A withNewTimestamp(StringBuilder arg1);
    public A withNewTimestamp(StringBuffer arg1);
    public A addToUsage(String key,Quantity value);
    public A addToUsage(Map<String,Quantity> map);
    public A removeFromUsage(String key);
    public A removeFromUsage(Map<String,Quantity> map);
    public Map<String,Quantity> getUsage();
    public A withUsage(Map<String,Quantity> usage);
    public Boolean hasUsage();
    
/**
 * This method has been deprecated, please use method buildWindow instead.
 * @return The buildable object.
 */
@Deprecated public Duration getWindow();
    public Duration buildWindow();
    public A withWindow(Duration window);
    public Boolean hasWindow();
    public A withNewWindow(Long duration);
    public A withNewWindow(String duration);
    public NodeMetricsFluent.WindowNested<A> withNewWindow();
    public NodeMetricsFluent.WindowNested<A> withNewWindowLike(Duration item);
    public NodeMetricsFluent.WindowNested<A> editWindow();
    public NodeMetricsFluent.WindowNested<A> editOrNewWindow();
    public NodeMetricsFluent.WindowNested<A> editOrNewWindowLike(Duration item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<NodeMetricsFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface WindowNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DurationFluent<NodeMetricsFluent.WindowNested<N>>{

        
    public N and();    public N endWindow();
}


}
