package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CSINodeBuilder extends CSINodeFluentImpl<CSINodeBuilder> implements VisitableBuilder<CSINode,CSINodeBuilder>{

    CSINodeFluent<?> fluent;
    Boolean validationEnabled;

    public CSINodeBuilder(){
            this(true);
    }
    public CSINodeBuilder(Boolean validationEnabled){
            this(new CSINode(), validationEnabled);
    }
    public CSINodeBuilder(CSINodeFluent<?> fluent){
            this(fluent, true);
    }
    public CSINodeBuilder(CSINodeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CSINode(), validationEnabled);
    }
    public CSINodeBuilder(CSINodeFluent<?> fluent,CSINode instance){
            this(fluent, instance, true);
    }
    public CSINodeBuilder(CSINodeFluent<?> fluent,CSINode instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public CSINodeBuilder(CSINode instance){
            this(instance,true);
    }
    public CSINodeBuilder(CSINode instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }

    public CSINode build(){
            CSINode buildable = new CSINode(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CSINodeBuilder that = (CSINodeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
