package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.model.DurationFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.util.List;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.DurationBuilder;

public class PodMetricsFluentImpl<A extends PodMetricsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PodMetricsFluent<A>{

    private String apiVersion;
    private List<ContainerMetricsBuilder> containers =  new ArrayList<ContainerMetricsBuilder>();
    private String kind;
    private ObjectMetaBuilder metadata;
    private String timestamp;
    private DurationBuilder window;

    public PodMetricsFluentImpl(){
    }
    public PodMetricsFluentImpl(PodMetrics instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withContainers(instance.getContainers()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withTimestamp(instance.getTimestamp()); 
            this.withWindow(instance.getWindow()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A addToContainers(int index,ContainerMetrics item){
            if (this.containers == null) {this.containers = new ArrayList<ContainerMetricsBuilder>();}
            ContainerMetricsBuilder builder = new ContainerMetricsBuilder(item);_visitables.get("containers").add(index >= 0 ? index : _visitables.get("containers").size(), builder);this.containers.add(index >= 0 ? index : containers.size(), builder); return (A)this;
    }

    public A setToContainers(int index,ContainerMetrics item){
            if (this.containers == null) {this.containers = new ArrayList<ContainerMetricsBuilder>();}
            ContainerMetricsBuilder builder = new ContainerMetricsBuilder(item);
            if (index < 0 || index >= _visitables.get("containers").size()) { _visitables.get("containers").add(builder); } else { _visitables.get("containers").set(index, builder);}
            if (index < 0 || index >= containers.size()) { containers.add(builder); } else { containers.set(index, builder);}
             return (A)this;
    }

    public A addToContainers(ContainerMetrics... items){
            if (this.containers == null) {this.containers = new ArrayList<ContainerMetricsBuilder>();}
            for (ContainerMetrics item : items) {ContainerMetricsBuilder builder = new ContainerMetricsBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
    }

    public A addAllToContainers(Collection<ContainerMetrics> items){
            if (this.containers == null) {this.containers = new ArrayList<ContainerMetricsBuilder>();}
            for (ContainerMetrics item : items) {ContainerMetricsBuilder builder = new ContainerMetricsBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
    }

    public A removeFromContainers(ContainerMetrics... items){
            for (ContainerMetrics item : items) {ContainerMetricsBuilder builder = new ContainerMetricsBuilder(item);_visitables.get("containers").remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
    }

    public A removeAllFromContainers(Collection<ContainerMetrics> items){
            for (ContainerMetrics item : items) {ContainerMetricsBuilder builder = new ContainerMetricsBuilder(item);_visitables.get("containers").remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromContainers(io.fabric8.kubernetes.api.builder.Predicate<ContainerMetricsBuilder> predicate){
            if (containers == null) return (A) this;
            final Iterator<ContainerMetricsBuilder> each = containers.iterator();
            final List visitables = _visitables.get("containers");
            while (each.hasNext()) {
              ContainerMetricsBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildContainers instead.
 * @return The buildable object.
 */
@Deprecated public List<ContainerMetrics> getContainers(){
            return build(containers);
    }

    public List<ContainerMetrics> buildContainers(){
            return build(containers);
    }

    public ContainerMetrics buildContainer(int index){
            return this.containers.get(index).build();
    }

    public ContainerMetrics buildFirstContainer(){
            return this.containers.get(0).build();
    }

    public ContainerMetrics buildLastContainer(){
            return this.containers.get(containers.size() - 1).build();
    }

    public ContainerMetrics buildMatchingContainer(io.fabric8.kubernetes.api.builder.Predicate<ContainerMetricsBuilder> predicate){
            for (ContainerMetricsBuilder item: containers) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingContainer(io.fabric8.kubernetes.api.builder.Predicate<ContainerMetricsBuilder> predicate){
            for (ContainerMetricsBuilder item: containers) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withContainers(List<ContainerMetrics> containers){
            if (this.containers != null) { _visitables.get("containers").removeAll(this.containers);}
            if (containers != null) {this.containers = new ArrayList<ContainerMetricsBuilder>(); for (ContainerMetrics item : containers){this.addToContainers(item);}} else { this.containers = null;} return (A) this;
    }

    public A withContainers(ContainerMetrics... containers){
            if (this.containers != null) {this.containers.clear();}
            if (containers != null) {for (ContainerMetrics item :containers){ this.addToContainers(item);}} return (A) this;
    }

    public Boolean hasContainers(){
            return containers != null && !containers.isEmpty();
    }

    public PodMetricsFluent.ContainersNested<A> addNewContainer(){
            return new ContainersNestedImpl();
    }

    public PodMetricsFluent.ContainersNested<A> addNewContainerLike(ContainerMetrics item){
            return new ContainersNestedImpl(-1, item);
    }

    public PodMetricsFluent.ContainersNested<A> setNewContainerLike(int index,ContainerMetrics item){
            return new ContainersNestedImpl(index, item);
    }

    public PodMetricsFluent.ContainersNested<A> editContainer(int index){
            if (containers.size() <= index) throw new RuntimeException("Can't edit containers. Index exceeds size.");
            return setNewContainerLike(index, buildContainer(index));
    }

    public PodMetricsFluent.ContainersNested<A> editFirstContainer(){
            if (containers.size() == 0) throw new RuntimeException("Can't edit first containers. The list is empty.");
            return setNewContainerLike(0, buildContainer(0));
    }

    public PodMetricsFluent.ContainersNested<A> editLastContainer(){
            int index = containers.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last containers. The list is empty.");
            return setNewContainerLike(index, buildContainer(index));
    }

    public PodMetricsFluent.ContainersNested<A> editMatchingContainer(io.fabric8.kubernetes.api.builder.Predicate<ContainerMetricsBuilder> predicate){
            int index = -1;
            for (int i=0;i<containers.size();i++) { 
            if (predicate.apply(containers.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching containers. No match found.");
            return setNewContainerLike(index, buildContainer(index));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.get("metadata").remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public PodMetricsFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public PodMetricsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public PodMetricsFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public PodMetricsFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public PodMetricsFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public String getTimestamp(){
            return this.timestamp;
    }

    public A withTimestamp(String timestamp){
            this.timestamp=timestamp; return (A) this;
    }

    public Boolean hasTimestamp(){
            return this.timestamp != null;
    }

    public A withNewTimestamp(String arg1){
            return (A)withTimestamp(new String(arg1));
    }

    public A withNewTimestamp(StringBuilder arg1){
            return (A)withTimestamp(new String(arg1));
    }

    public A withNewTimestamp(StringBuffer arg1){
            return (A)withTimestamp(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildWindow instead.
 * @return The buildable object.
 */
@Deprecated public Duration getWindow(){
            return this.window!=null?this.window.build():null;
    }

    public Duration buildWindow(){
            return this.window!=null?this.window.build():null;
    }

    public A withWindow(Duration window){
            _visitables.get("window").remove(this.window);
            if (window!=null){ this.window= new DurationBuilder(window); _visitables.get("window").add(this.window);} return (A) this;
    }

    public Boolean hasWindow(){
            return this.window != null;
    }

    public A withNewWindow(Long duration){
            return (A)withWindow(new Duration(duration));
    }

    public A withNewWindow(String duration){
            return (A)withWindow(new Duration(duration));
    }

    public PodMetricsFluent.WindowNested<A> withNewWindow(){
            return new WindowNestedImpl();
    }

    public PodMetricsFluent.WindowNested<A> withNewWindowLike(Duration item){
            return new WindowNestedImpl(item);
    }

    public PodMetricsFluent.WindowNested<A> editWindow(){
            return withNewWindowLike(getWindow());
    }

    public PodMetricsFluent.WindowNested<A> editOrNewWindow(){
            return withNewWindowLike(getWindow() != null ? getWindow(): new DurationBuilder().build());
    }

    public PodMetricsFluent.WindowNested<A> editOrNewWindowLike(Duration item){
            return withNewWindowLike(getWindow() != null ? getWindow(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            PodMetricsFluentImpl that = (PodMetricsFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (containers != null ? !containers.equals(that.containers) :that.containers != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (timestamp != null ? !timestamp.equals(that.timestamp) :that.timestamp != null) return false;
            if (window != null ? !window.equals(that.window) :that.window != null) return false;
            return true;
    }


    public class ContainersNestedImpl<N> extends ContainerMetricsFluentImpl<PodMetricsFluent.ContainersNested<N>> implements PodMetricsFluent.ContainersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ContainerMetricsBuilder builder;
        private final int index;
    
            ContainersNestedImpl(int index,ContainerMetrics item){
                    this.index = index;
                    this.builder = new ContainerMetricsBuilder(this, item);
            }
            ContainersNestedImpl(){
                    this.index = -1;
                    this.builder = new ContainerMetricsBuilder(this);
            }
    
    public N and(){
            return (N) PodMetricsFluentImpl.this.setToContainers(index,builder.build());
    }
    public N endContainer(){
            return and();
    }

}
    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<PodMetricsFluent.MetadataNested<N>> implements PodMetricsFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) PodMetricsFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class WindowNestedImpl<N> extends DurationFluentImpl<PodMetricsFluent.WindowNested<N>> implements PodMetricsFluent.WindowNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            WindowNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            WindowNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) PodMetricsFluentImpl.this.withWindow(builder.build());
    }
    public N endWindow(){
            return and();
    }

}


}
