package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface EndpointsListFluent<A extends EndpointsListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Endpoints item);
    public A setToItems(int index,Endpoints item);
    public A addToItems(Endpoints... items);
    public A addAllToItems(Collection<Endpoints> items);
    public A removeFromItems(Endpoints... items);
    public A removeAllFromItems(Collection<Endpoints> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Endpoints> getItems();
    public List<Endpoints> buildItems();
    public Endpoints buildItem(int index);
    public Endpoints buildFirstItem();
    public Endpoints buildLastItem();
    public Endpoints buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<EndpointsBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<EndpointsBuilder> predicate);
    public A withItems(List<Endpoints> items);
    public A withItems(Endpoints... items);
    public Boolean hasItems();
    public EndpointsListFluent.ItemsNested<A> addNewItem();
    public EndpointsListFluent.ItemsNested<A> addNewItemLike(Endpoints item);
    public EndpointsListFluent.ItemsNested<A> setNewItemLike(int index,Endpoints item);
    public EndpointsListFluent.ItemsNested<A> editItem(int index);
    public EndpointsListFluent.ItemsNested<A> editFirstItem();
    public EndpointsListFluent.ItemsNested<A> editLastItem();
    public EndpointsListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<EndpointsBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ListMeta getMetadata();
    public ListMeta buildMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public EndpointsListFluent.MetadataNested<A> withNewMetadata();
    public EndpointsListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public EndpointsListFluent.MetadataNested<A> editMetadata();
    public EndpointsListFluent.MetadataNested<A> editOrNewMetadata();
    public EndpointsListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EndpointsFluent<EndpointsListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<EndpointsListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
