
package io.fabric8.kubernetes.api.model.authorization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "evaluationError",
    "incomplete",
    "nonResourceRules",
    "resourceRules"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class SubjectRulesReviewStatus implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("evaluationError")
    private String evaluationError;
    /**
     * 
     * 
     */
    @JsonProperty("incomplete")
    private Boolean incomplete;
    /**
     * 
     * 
     */
    @JsonProperty("nonResourceRules")
    private List<NonResourceRule> nonResourceRules = new ArrayList<NonResourceRule>();
    /**
     * 
     * 
     */
    @JsonProperty("resourceRules")
    private List<ResourceRule> resourceRules = new ArrayList<ResourceRule>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public SubjectRulesReviewStatus() {
    }

    /**
     * 
     * @param incomplete
     * @param nonResourceRules
     * @param resourceRules
     * @param evaluationError
     */
    public SubjectRulesReviewStatus(String evaluationError, Boolean incomplete, List<NonResourceRule> nonResourceRules, List<ResourceRule> resourceRules) {
        this.evaluationError = evaluationError;
        this.incomplete = incomplete;
        this.nonResourceRules = nonResourceRules;
        this.resourceRules = resourceRules;
    }

    /**
     * 
     * 
     * @return
     *     The evaluationError
     */
    @JsonProperty("evaluationError")
    public String getEvaluationError() {
        return evaluationError;
    }

    /**
     * 
     * 
     * @param evaluationError
     *     The evaluationError
     */
    @JsonProperty("evaluationError")
    public void setEvaluationError(String evaluationError) {
        this.evaluationError = evaluationError;
    }

    /**
     * 
     * 
     * @return
     *     The incomplete
     */
    @JsonProperty("incomplete")
    public Boolean getIncomplete() {
        return incomplete;
    }

    /**
     * 
     * 
     * @param incomplete
     *     The incomplete
     */
    @JsonProperty("incomplete")
    public void setIncomplete(Boolean incomplete) {
        this.incomplete = incomplete;
    }

    /**
     * 
     * 
     * @return
     *     The nonResourceRules
     */
    @JsonProperty("nonResourceRules")
    public List<NonResourceRule> getNonResourceRules() {
        return nonResourceRules;
    }

    /**
     * 
     * 
     * @param nonResourceRules
     *     The nonResourceRules
     */
    @JsonProperty("nonResourceRules")
    public void setNonResourceRules(List<NonResourceRule> nonResourceRules) {
        this.nonResourceRules = nonResourceRules;
    }

    /**
     * 
     * 
     * @return
     *     The resourceRules
     */
    @JsonProperty("resourceRules")
    public List<ResourceRule> getResourceRules() {
        return resourceRules;
    }

    /**
     * 
     * 
     * @param resourceRules
     *     The resourceRules
     */
    @JsonProperty("resourceRules")
    public void setResourceRules(List<ResourceRule> resourceRules) {
        this.resourceRules = resourceRules;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
