package io.fabric8.kubernetes.api.model.admissionregistration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Integer;
import java.lang.StringBuffer;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

public interface WebhookFluent<A extends WebhookFluent<A>> extends Fluent<A>{


    public A addToAdmissionReviewVersions(int index,String item);
    public A setToAdmissionReviewVersions(int index,String item);
    public A addToAdmissionReviewVersions(String... items);
    public A addAllToAdmissionReviewVersions(Collection<String> items);
    public A removeFromAdmissionReviewVersions(String... items);
    public A removeAllFromAdmissionReviewVersions(Collection<String> items);
    public List<String> getAdmissionReviewVersions();
    public String getAdmissionReviewVersion(int index);
    public String getFirstAdmissionReviewVersion();
    public String getLastAdmissionReviewVersion();
    public String getMatchingAdmissionReviewVersion(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingAdmissionReviewVersion(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withAdmissionReviewVersions(List<String> admissionReviewVersions);
    public A withAdmissionReviewVersions(String... admissionReviewVersions);
    public Boolean hasAdmissionReviewVersions();
    public A addNewAdmissionReviewVersion(String arg1);
    public A addNewAdmissionReviewVersion(StringBuilder arg1);
    public A addNewAdmissionReviewVersion(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildClientConfig instead.
 * @return The buildable object.
 */
@Deprecated public WebhookClientConfig getClientConfig();
    public WebhookClientConfig buildClientConfig();
    public A withClientConfig(WebhookClientConfig clientConfig);
    public Boolean hasClientConfig();
    public WebhookFluent.ClientConfigNested<A> withNewClientConfig();
    public WebhookFluent.ClientConfigNested<A> withNewClientConfigLike(WebhookClientConfig item);
    public WebhookFluent.ClientConfigNested<A> editClientConfig();
    public WebhookFluent.ClientConfigNested<A> editOrNewClientConfig();
    public WebhookFluent.ClientConfigNested<A> editOrNewClientConfigLike(WebhookClientConfig item);
    public String getFailurePolicy();
    public A withFailurePolicy(String failurePolicy);
    public Boolean hasFailurePolicy();
    public A withNewFailurePolicy(String arg1);
    public A withNewFailurePolicy(StringBuilder arg1);
    public A withNewFailurePolicy(StringBuffer arg1);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildNamespaceSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getNamespaceSelector();
    public LabelSelector buildNamespaceSelector();
    public A withNamespaceSelector(LabelSelector namespaceSelector);
    public Boolean hasNamespaceSelector();
    public WebhookFluent.NamespaceSelectorNested<A> withNewNamespaceSelector();
    public WebhookFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item);
    public WebhookFluent.NamespaceSelectorNested<A> editNamespaceSelector();
    public WebhookFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector();
    public WebhookFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item);
    public A addToRules(int index,RuleWithOperations item);
    public A setToRules(int index,RuleWithOperations item);
    public A addToRules(RuleWithOperations... items);
    public A addAllToRules(Collection<RuleWithOperations> items);
    public A removeFromRules(RuleWithOperations... items);
    public A removeAllFromRules(Collection<RuleWithOperations> items);
    
/**
 * This method has been deprecated, please use method buildRules instead.
 * @return The buildable object.
 */
@Deprecated public List<RuleWithOperations> getRules();
    public List<RuleWithOperations> buildRules();
    public RuleWithOperations buildRule(int index);
    public RuleWithOperations buildFirstRule();
    public RuleWithOperations buildLastRule();
    public RuleWithOperations buildMatchingRule(io.fabric8.kubernetes.api.builder.Predicate<RuleWithOperationsBuilder> predicate);
    public Boolean hasMatchingRule(io.fabric8.kubernetes.api.builder.Predicate<RuleWithOperationsBuilder> predicate);
    public A withRules(List<RuleWithOperations> rules);
    public A withRules(RuleWithOperations... rules);
    public Boolean hasRules();
    public WebhookFluent.RulesNested<A> addNewRule();
    public WebhookFluent.RulesNested<A> addNewRuleLike(RuleWithOperations item);
    public WebhookFluent.RulesNested<A> setNewRuleLike(int index,RuleWithOperations item);
    public WebhookFluent.RulesNested<A> editRule(int index);
    public WebhookFluent.RulesNested<A> editFirstRule();
    public WebhookFluent.RulesNested<A> editLastRule();
    public WebhookFluent.RulesNested<A> editMatchingRule(io.fabric8.kubernetes.api.builder.Predicate<RuleWithOperationsBuilder> predicate);
    public String getSideEffects();
    public A withSideEffects(String sideEffects);
    public Boolean hasSideEffects();
    public A withNewSideEffects(String arg1);
    public A withNewSideEffects(StringBuilder arg1);
    public A withNewSideEffects(StringBuffer arg1);
    public Integer getTimeoutSeconds();
    public A withTimeoutSeconds(Integer timeoutSeconds);
    public Boolean hasTimeoutSeconds();

    public interface ClientConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,WebhookClientConfigFluent<WebhookFluent.ClientConfigNested<N>>{

        
    public N and();    public N endClientConfig();
}
    public interface NamespaceSelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<WebhookFluent.NamespaceSelectorNested<N>>{

        
    public N and();    public N endNamespaceSelector();
}
    public interface RulesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RuleWithOperationsFluent<WebhookFluent.RulesNested<N>>{

        
    public N and();    public N endRule();
}


}
