package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ServerAddressByClientCIDRBuilder extends ServerAddressByClientCIDRFluentImpl<ServerAddressByClientCIDRBuilder> implements VisitableBuilder<ServerAddressByClientCIDR,ServerAddressByClientCIDRBuilder>{

    ServerAddressByClientCIDRFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ServerAddressByClientCIDRBuilder(){
            this(true);
    }
    public ServerAddressByClientCIDRBuilder(Boolean validationEnabled){
            this(new ServerAddressByClientCIDR(), validationEnabled);
    }
    public ServerAddressByClientCIDRBuilder(ServerAddressByClientCIDRFluent<?> fluent){
            this(fluent, true);
    }
    public ServerAddressByClientCIDRBuilder(ServerAddressByClientCIDRFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ServerAddressByClientCIDR(), validationEnabled);
    }
    public ServerAddressByClientCIDRBuilder(ServerAddressByClientCIDRFluent<?> fluent,ServerAddressByClientCIDR instance){
            this(fluent, instance, true);
    }
    public ServerAddressByClientCIDRBuilder(ServerAddressByClientCIDRFluent<?> fluent,ServerAddressByClientCIDR instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withClientCIDR(instance.getClientCIDR()); 
            fluent.withServerAddress(instance.getServerAddress()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServerAddressByClientCIDRBuilder(ServerAddressByClientCIDR instance){
            this(instance,true);
    }
    public ServerAddressByClientCIDRBuilder(ServerAddressByClientCIDR instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withClientCIDR(instance.getClientCIDR()); 
            this.withServerAddress(instance.getServerAddress()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServerAddressByClientCIDRBuilder(Validator validator){
            this(new ServerAddressByClientCIDR(), true);
    }
    public ServerAddressByClientCIDRBuilder(ServerAddressByClientCIDRFluent<?> fluent,ServerAddressByClientCIDR instance,Validator validator){
            this.fluent = fluent; 
            fluent.withClientCIDR(instance.getClientCIDR()); 
            fluent.withServerAddress(instance.getServerAddress()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ServerAddressByClientCIDRBuilder(ServerAddressByClientCIDR instance,Validator validator){
            this.fluent = this; 
            this.withClientCIDR(instance.getClientCIDR()); 
            this.withServerAddress(instance.getServerAddress()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ServerAddressByClientCIDR build(){
            ServerAddressByClientCIDR buildable = new ServerAddressByClientCIDR(fluent.getClientCIDR(),fluent.getServerAddress());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServerAddressByClientCIDRBuilder that = (ServerAddressByClientCIDRBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
