package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;

public class APIGroupFluentImpl<A extends APIGroupFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements APIGroupFluent<A>{

    private String apiVersion;
    private String kind;
    private String name;
    private GroupVersionForDiscoveryBuilder preferredVersion;
    private List<ServerAddressByClientCIDRBuilder> serverAddressByClientCIDRs;
    private List<GroupVersionForDiscoveryBuilder> versions;

    public APIGroupFluentImpl(){
    }
    public APIGroupFluentImpl(APIGroup instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withName(instance.getName()); 
            this.withPreferredVersion(instance.getPreferredVersion()); 
            this.withServerAddressByClientCIDRs(instance.getServerAddressByClientCIDRs()); 
            this.withVersions(instance.getVersions()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildPreferredVersion instead.
 * @return The buildable object.
 */
@Deprecated public GroupVersionForDiscovery getPreferredVersion(){
            return this.preferredVersion!=null?this.preferredVersion.build():null;
    }

    public GroupVersionForDiscovery buildPreferredVersion(){
            return this.preferredVersion!=null?this.preferredVersion.build():null;
    }

    public A withPreferredVersion(GroupVersionForDiscovery preferredVersion){
            _visitables.get("preferredVersion").remove(this.preferredVersion);
            if (preferredVersion!=null){ this.preferredVersion= new GroupVersionForDiscoveryBuilder(preferredVersion); _visitables.get("preferredVersion").add(this.preferredVersion);} return (A) this;
    }

    public Boolean hasPreferredVersion(){
            return this.preferredVersion != null;
    }

    public A withNewPreferredVersion(String groupVersion,String version){
            return (A)withPreferredVersion(new GroupVersionForDiscovery(groupVersion, version));
    }

    public APIGroupFluent.PreferredVersionNested<A> withNewPreferredVersion(){
            return new PreferredVersionNestedImpl();
    }

    public APIGroupFluent.PreferredVersionNested<A> withNewPreferredVersionLike(GroupVersionForDiscovery item){
            return new PreferredVersionNestedImpl(item);
    }

    public APIGroupFluent.PreferredVersionNested<A> editPreferredVersion(){
            return withNewPreferredVersionLike(getPreferredVersion());
    }

    public APIGroupFluent.PreferredVersionNested<A> editOrNewPreferredVersion(){
            return withNewPreferredVersionLike(getPreferredVersion() != null ? getPreferredVersion(): new GroupVersionForDiscoveryBuilder().build());
    }

    public APIGroupFluent.PreferredVersionNested<A> editOrNewPreferredVersionLike(GroupVersionForDiscovery item){
            return withNewPreferredVersionLike(getPreferredVersion() != null ? getPreferredVersion(): item);
    }

    public A addToServerAddressByClientCIDRs(int index,ServerAddressByClientCIDR item){
            if (this.serverAddressByClientCIDRs == null) {this.serverAddressByClientCIDRs = new ArrayList<ServerAddressByClientCIDRBuilder>();}
            ServerAddressByClientCIDRBuilder builder = new ServerAddressByClientCIDRBuilder(item);_visitables.get("serverAddressByClientCIDRs").add(index >= 0 ? index : _visitables.get("serverAddressByClientCIDRs").size(), builder);this.serverAddressByClientCIDRs.add(index >= 0 ? index : serverAddressByClientCIDRs.size(), builder); return (A)this;
    }

    public A setToServerAddressByClientCIDRs(int index,ServerAddressByClientCIDR item){
            if (this.serverAddressByClientCIDRs == null) {this.serverAddressByClientCIDRs = new ArrayList<ServerAddressByClientCIDRBuilder>();}
            ServerAddressByClientCIDRBuilder builder = new ServerAddressByClientCIDRBuilder(item);
            if (index < 0 || index >= _visitables.get("serverAddressByClientCIDRs").size()) { _visitables.get("serverAddressByClientCIDRs").add(builder); } else { _visitables.get("serverAddressByClientCIDRs").set(index, builder);}
            if (index < 0 || index >= serverAddressByClientCIDRs.size()) { serverAddressByClientCIDRs.add(builder); } else { serverAddressByClientCIDRs.set(index, builder);}
             return (A)this;
    }

    public A addToServerAddressByClientCIDRs(ServerAddressByClientCIDR... items){
            if (this.serverAddressByClientCIDRs == null) {this.serverAddressByClientCIDRs = new ArrayList<ServerAddressByClientCIDRBuilder>();}
            for (ServerAddressByClientCIDR item : items) {ServerAddressByClientCIDRBuilder builder = new ServerAddressByClientCIDRBuilder(item);_visitables.get("serverAddressByClientCIDRs").add(builder);this.serverAddressByClientCIDRs.add(builder);} return (A)this;
    }

    public A addAllToServerAddressByClientCIDRs(Collection<ServerAddressByClientCIDR> items){
            if (this.serverAddressByClientCIDRs == null) {this.serverAddressByClientCIDRs = new ArrayList<ServerAddressByClientCIDRBuilder>();}
            for (ServerAddressByClientCIDR item : items) {ServerAddressByClientCIDRBuilder builder = new ServerAddressByClientCIDRBuilder(item);_visitables.get("serverAddressByClientCIDRs").add(builder);this.serverAddressByClientCIDRs.add(builder);} return (A)this;
    }

    public A removeFromServerAddressByClientCIDRs(ServerAddressByClientCIDR... items){
            for (ServerAddressByClientCIDR item : items) {ServerAddressByClientCIDRBuilder builder = new ServerAddressByClientCIDRBuilder(item);_visitables.get("serverAddressByClientCIDRs").remove(builder);if (this.serverAddressByClientCIDRs != null) {this.serverAddressByClientCIDRs.remove(builder);}} return (A)this;
    }

    public A removeAllFromServerAddressByClientCIDRs(Collection<ServerAddressByClientCIDR> items){
            for (ServerAddressByClientCIDR item : items) {ServerAddressByClientCIDRBuilder builder = new ServerAddressByClientCIDRBuilder(item);_visitables.get("serverAddressByClientCIDRs").remove(builder);if (this.serverAddressByClientCIDRs != null) {this.serverAddressByClientCIDRs.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildServerAddressByClientCIDRs instead.
 * @return The buildable object.
 */
@Deprecated public List<ServerAddressByClientCIDR> getServerAddressByClientCIDRs(){
            return build(serverAddressByClientCIDRs);
    }

    public List<ServerAddressByClientCIDR> buildServerAddressByClientCIDRs(){
            return build(serverAddressByClientCIDRs);
    }

    public ServerAddressByClientCIDR buildServerAddressByClientCIDR(int index){
            return this.serverAddressByClientCIDRs.get(index).build();
    }

    public ServerAddressByClientCIDR buildFirstServerAddressByClientCIDR(){
            return this.serverAddressByClientCIDRs.get(0).build();
    }

    public ServerAddressByClientCIDR buildLastServerAddressByClientCIDR(){
            return this.serverAddressByClientCIDRs.get(serverAddressByClientCIDRs.size() - 1).build();
    }

    public ServerAddressByClientCIDR buildMatchingServerAddressByClientCIDR(io.fabric8.kubernetes.api.builder.Predicate<ServerAddressByClientCIDRBuilder> predicate){
            for (ServerAddressByClientCIDRBuilder item: serverAddressByClientCIDRs) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingServerAddressByClientCIDR(io.fabric8.kubernetes.api.builder.Predicate<ServerAddressByClientCIDRBuilder> predicate){
            for (ServerAddressByClientCIDRBuilder item: serverAddressByClientCIDRs) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withServerAddressByClientCIDRs(List<ServerAddressByClientCIDR> serverAddressByClientCIDRs){
            if (this.serverAddressByClientCIDRs != null) { _visitables.get("serverAddressByClientCIDRs").removeAll(this.serverAddressByClientCIDRs);}
            if (serverAddressByClientCIDRs != null) {this.serverAddressByClientCIDRs = new ArrayList<ServerAddressByClientCIDRBuilder>(); for (ServerAddressByClientCIDR item : serverAddressByClientCIDRs){this.addToServerAddressByClientCIDRs(item);}} else { this.serverAddressByClientCIDRs = new ArrayList<ServerAddressByClientCIDRBuilder>();} return (A) this;
    }

    public A withServerAddressByClientCIDRs(ServerAddressByClientCIDR... serverAddressByClientCIDRs){
            if (this.serverAddressByClientCIDRs != null) {this.serverAddressByClientCIDRs.clear();}
            if (serverAddressByClientCIDRs != null) {for (ServerAddressByClientCIDR item :serverAddressByClientCIDRs){ this.addToServerAddressByClientCIDRs(item);}} return (A) this;
    }

    public Boolean hasServerAddressByClientCIDRs(){
            return serverAddressByClientCIDRs != null && !serverAddressByClientCIDRs.isEmpty();
    }

    public A addNewServerAddressByClientCIDR(String clientCIDR,String serverAddress){
            return (A)addToServerAddressByClientCIDRs(new ServerAddressByClientCIDR(clientCIDR, serverAddress));
    }

    public APIGroupFluent.ServerAddressByClientCIDRsNested<A> addNewServerAddressByClientCIDR(){
            return new ServerAddressByClientCIDRsNestedImpl();
    }

    public APIGroupFluent.ServerAddressByClientCIDRsNested<A> addNewServerAddressByClientCIDRLike(ServerAddressByClientCIDR item){
            return new ServerAddressByClientCIDRsNestedImpl(-1, item);
    }

    public APIGroupFluent.ServerAddressByClientCIDRsNested<A> setNewServerAddressByClientCIDRLike(int index,ServerAddressByClientCIDR item){
            return new ServerAddressByClientCIDRsNestedImpl(index, item);
    }

    public APIGroupFluent.ServerAddressByClientCIDRsNested<A> editServerAddressByClientCIDR(int index){
            if (serverAddressByClientCIDRs.size() <= index) throw new RuntimeException("Can't edit serverAddressByClientCIDRs. Index exceeds size.");
            return setNewServerAddressByClientCIDRLike(index, buildServerAddressByClientCIDR(index));
    }

    public APIGroupFluent.ServerAddressByClientCIDRsNested<A> editFirstServerAddressByClientCIDR(){
            if (serverAddressByClientCIDRs.size() == 0) throw new RuntimeException("Can't edit first serverAddressByClientCIDRs. The list is empty.");
            return setNewServerAddressByClientCIDRLike(0, buildServerAddressByClientCIDR(0));
    }

    public APIGroupFluent.ServerAddressByClientCIDRsNested<A> editLastServerAddressByClientCIDR(){
            int index = serverAddressByClientCIDRs.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last serverAddressByClientCIDRs. The list is empty.");
            return setNewServerAddressByClientCIDRLike(index, buildServerAddressByClientCIDR(index));
    }

    public APIGroupFluent.ServerAddressByClientCIDRsNested<A> editMatchingServerAddressByClientCIDR(io.fabric8.kubernetes.api.builder.Predicate<ServerAddressByClientCIDRBuilder> predicate){
            int index = -1;
            for (int i=0;i<serverAddressByClientCIDRs.size();i++) { 
            if (predicate.apply(serverAddressByClientCIDRs.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching serverAddressByClientCIDRs. No match found.");
            return setNewServerAddressByClientCIDRLike(index, buildServerAddressByClientCIDR(index));
    }

    public A addToVersions(int index,GroupVersionForDiscovery item){
            if (this.versions == null) {this.versions = new ArrayList<GroupVersionForDiscoveryBuilder>();}
            GroupVersionForDiscoveryBuilder builder = new GroupVersionForDiscoveryBuilder(item);_visitables.get("versions").add(index >= 0 ? index : _visitables.get("versions").size(), builder);this.versions.add(index >= 0 ? index : versions.size(), builder); return (A)this;
    }

    public A setToVersions(int index,GroupVersionForDiscovery item){
            if (this.versions == null) {this.versions = new ArrayList<GroupVersionForDiscoveryBuilder>();}
            GroupVersionForDiscoveryBuilder builder = new GroupVersionForDiscoveryBuilder(item);
            if (index < 0 || index >= _visitables.get("versions").size()) { _visitables.get("versions").add(builder); } else { _visitables.get("versions").set(index, builder);}
            if (index < 0 || index >= versions.size()) { versions.add(builder); } else { versions.set(index, builder);}
             return (A)this;
    }

    public A addToVersions(GroupVersionForDiscovery... items){
            if (this.versions == null) {this.versions = new ArrayList<GroupVersionForDiscoveryBuilder>();}
            for (GroupVersionForDiscovery item : items) {GroupVersionForDiscoveryBuilder builder = new GroupVersionForDiscoveryBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
    }

    public A addAllToVersions(Collection<GroupVersionForDiscovery> items){
            if (this.versions == null) {this.versions = new ArrayList<GroupVersionForDiscoveryBuilder>();}
            for (GroupVersionForDiscovery item : items) {GroupVersionForDiscoveryBuilder builder = new GroupVersionForDiscoveryBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
    }

    public A removeFromVersions(GroupVersionForDiscovery... items){
            for (GroupVersionForDiscovery item : items) {GroupVersionForDiscoveryBuilder builder = new GroupVersionForDiscoveryBuilder(item);_visitables.get("versions").remove(builder);if (this.versions != null) {this.versions.remove(builder);}} return (A)this;
    }

    public A removeAllFromVersions(Collection<GroupVersionForDiscovery> items){
            for (GroupVersionForDiscovery item : items) {GroupVersionForDiscoveryBuilder builder = new GroupVersionForDiscoveryBuilder(item);_visitables.get("versions").remove(builder);if (this.versions != null) {this.versions.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildVersions instead.
 * @return The buildable object.
 */
@Deprecated public List<GroupVersionForDiscovery> getVersions(){
            return build(versions);
    }

    public List<GroupVersionForDiscovery> buildVersions(){
            return build(versions);
    }

    public GroupVersionForDiscovery buildVersion(int index){
            return this.versions.get(index).build();
    }

    public GroupVersionForDiscovery buildFirstVersion(){
            return this.versions.get(0).build();
    }

    public GroupVersionForDiscovery buildLastVersion(){
            return this.versions.get(versions.size() - 1).build();
    }

    public GroupVersionForDiscovery buildMatchingVersion(io.fabric8.kubernetes.api.builder.Predicate<GroupVersionForDiscoveryBuilder> predicate){
            for (GroupVersionForDiscoveryBuilder item: versions) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingVersion(io.fabric8.kubernetes.api.builder.Predicate<GroupVersionForDiscoveryBuilder> predicate){
            for (GroupVersionForDiscoveryBuilder item: versions) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withVersions(List<GroupVersionForDiscovery> versions){
            if (this.versions != null) { _visitables.get("versions").removeAll(this.versions);}
            if (versions != null) {this.versions = new ArrayList<GroupVersionForDiscoveryBuilder>(); for (GroupVersionForDiscovery item : versions){this.addToVersions(item);}} else { this.versions = new ArrayList<GroupVersionForDiscoveryBuilder>();} return (A) this;
    }

    public A withVersions(GroupVersionForDiscovery... versions){
            if (this.versions != null) {this.versions.clear();}
            if (versions != null) {for (GroupVersionForDiscovery item :versions){ this.addToVersions(item);}} return (A) this;
    }

    public Boolean hasVersions(){
            return versions != null && !versions.isEmpty();
    }

    public A addNewVersion(String groupVersion,String version){
            return (A)addToVersions(new GroupVersionForDiscovery(groupVersion, version));
    }

    public APIGroupFluent.VersionsNested<A> addNewVersion(){
            return new VersionsNestedImpl();
    }

    public APIGroupFluent.VersionsNested<A> addNewVersionLike(GroupVersionForDiscovery item){
            return new VersionsNestedImpl(-1, item);
    }

    public APIGroupFluent.VersionsNested<A> setNewVersionLike(int index,GroupVersionForDiscovery item){
            return new VersionsNestedImpl(index, item);
    }

    public APIGroupFluent.VersionsNested<A> editVersion(int index){
            if (versions.size() <= index) throw new RuntimeException("Can't edit versions. Index exceeds size.");
            return setNewVersionLike(index, buildVersion(index));
    }

    public APIGroupFluent.VersionsNested<A> editFirstVersion(){
            if (versions.size() == 0) throw new RuntimeException("Can't edit first versions. The list is empty.");
            return setNewVersionLike(0, buildVersion(0));
    }

    public APIGroupFluent.VersionsNested<A> editLastVersion(){
            int index = versions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last versions. The list is empty.");
            return setNewVersionLike(index, buildVersion(index));
    }

    public APIGroupFluent.VersionsNested<A> editMatchingVersion(io.fabric8.kubernetes.api.builder.Predicate<GroupVersionForDiscoveryBuilder> predicate){
            int index = -1;
            for (int i=0;i<versions.size();i++) { 
            if (predicate.apply(versions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching versions. No match found.");
            return setNewVersionLike(index, buildVersion(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            APIGroupFluentImpl that = (APIGroupFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (preferredVersion != null ? !preferredVersion.equals(that.preferredVersion) :that.preferredVersion != null) return false;
            if (serverAddressByClientCIDRs != null ? !serverAddressByClientCIDRs.equals(that.serverAddressByClientCIDRs) :that.serverAddressByClientCIDRs != null) return false;
            if (versions != null ? !versions.equals(that.versions) :that.versions != null) return false;
            return true;
    }


    public class PreferredVersionNestedImpl<N> extends GroupVersionForDiscoveryFluentImpl<APIGroupFluent.PreferredVersionNested<N>> implements APIGroupFluent.PreferredVersionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final GroupVersionForDiscoveryBuilder builder;
    
            PreferredVersionNestedImpl(GroupVersionForDiscovery item){
                    this.builder = new GroupVersionForDiscoveryBuilder(this, item);
            }
            PreferredVersionNestedImpl(){
                    this.builder = new GroupVersionForDiscoveryBuilder(this);
            }
    
    public N and(){
            return (N) APIGroupFluentImpl.this.withPreferredVersion(builder.build());
    }
    public N endPreferredVersion(){
            return and();
    }

}
    public class ServerAddressByClientCIDRsNestedImpl<N> extends ServerAddressByClientCIDRFluentImpl<APIGroupFluent.ServerAddressByClientCIDRsNested<N>> implements APIGroupFluent.ServerAddressByClientCIDRsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ServerAddressByClientCIDRBuilder builder;
        private final int index;
    
            ServerAddressByClientCIDRsNestedImpl(int index,ServerAddressByClientCIDR item){
                    this.index = index;
                    this.builder = new ServerAddressByClientCIDRBuilder(this, item);
            }
            ServerAddressByClientCIDRsNestedImpl(){
                    this.index = -1;
                    this.builder = new ServerAddressByClientCIDRBuilder(this);
            }
    
    public N and(){
            return (N) APIGroupFluentImpl.this.setToServerAddressByClientCIDRs(index, builder.build());
    }
    public N endServerAddressByClientCIDR(){
            return and();
    }

}
    public class VersionsNestedImpl<N> extends GroupVersionForDiscoveryFluentImpl<APIGroupFluent.VersionsNested<N>> implements APIGroupFluent.VersionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final GroupVersionForDiscoveryBuilder builder;
        private final int index;
    
            VersionsNestedImpl(int index,GroupVersionForDiscovery item){
                    this.index = index;
                    this.builder = new GroupVersionForDiscoveryBuilder(this, item);
            }
            VersionsNestedImpl(){
                    this.index = -1;
                    this.builder = new GroupVersionForDiscoveryBuilder(this);
            }
    
    public N and(){
            return (N) APIGroupFluentImpl.this.setToVersions(index, builder.build());
    }
    public N endVersion(){
            return and();
    }

}


}
