package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class BuildBuilder extends BuildFluentImpl<BuildBuilder> implements VisitableBuilder<Build,BuildBuilder>{

    BuildFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public BuildBuilder(){
            this(true);
    }
    public BuildBuilder(Boolean validationEnabled){
            this(new Build(), validationEnabled);
    }
    public BuildBuilder(BuildFluent<?> fluent){
            this(fluent, true);
    }
    public BuildBuilder(BuildFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Build(), validationEnabled);
    }
    public BuildBuilder(BuildFluent<?> fluent,Build instance){
            this(fluent, instance, true);
    }
    public BuildBuilder(BuildFluent<?> fluent,Build instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public BuildBuilder(Build instance){
            this(instance,true);
    }
    public BuildBuilder(Build instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public BuildBuilder(Validator validator){
            this(new Build(), true);
    }
    public BuildBuilder(BuildFluent<?> fluent,Build instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public BuildBuilder(Build instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Build build(){
            Build buildable = new Build(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BuildBuilder that = (BuildBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
