/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.AffinityBuilder;
import io.fabric8.kubernetes.api.model.AffinityFluentImpl;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.HostAlias;
import io.fabric8.kubernetes.api.model.HostAliasBuilder;
import io.fabric8.kubernetes.api.model.HostAliasFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.PodDNSConfig;
import io.fabric8.kubernetes.api.model.PodDNSConfigBuilder;
import io.fabric8.kubernetes.api.model.PodDNSConfigFluentImpl;
import io.fabric8.kubernetes.api.model.PodReadinessGate;
import io.fabric8.kubernetes.api.model.PodReadinessGateBuilder;
import io.fabric8.kubernetes.api.model.PodReadinessGateFluentImpl;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.PodSecurityContextBuilder;
import io.fabric8.kubernetes.api.model.PodSecurityContextFluentImpl;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.TolerationBuilder;
import io.fabric8.kubernetes.api.model.TolerationFluentImpl;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PodSpecFluentImpl<A extends PodSpecFluent<A>>
extends BaseFluent<A>
implements PodSpecFluent<A> {
    private Long activeDeadlineSeconds;
    private AffinityBuilder affinity;
    private Boolean automountServiceAccountToken;
    private List<ContainerBuilder> containers;
    private PodDNSConfigBuilder dnsConfig;
    private String dnsPolicy;
    private Boolean enableServiceLinks;
    private List<HostAliasBuilder> hostAliases;
    private Boolean hostIPC;
    private Boolean hostNetwork;
    private Boolean hostPID;
    private String hostname;
    private List<LocalObjectReferenceBuilder> imagePullSecrets;
    private List<ContainerBuilder> initContainers;
    private String nodeName;
    private Map<String, String> nodeSelector;
    private Integer priority;
    private String priorityClassName;
    private List<PodReadinessGateBuilder> readinessGates;
    private String restartPolicy;
    private String runtimeClassName;
    private String schedulerName;
    private PodSecurityContextBuilder securityContext;
    private String serviceAccount;
    private String serviceAccountName;
    private Boolean shareProcessNamespace;
    private String subdomain;
    private Long terminationGracePeriodSeconds;
    private List<TolerationBuilder> tolerations;
    private List<VolumeBuilder> volumes;

    public PodSpecFluentImpl() {
    }

    public PodSpecFluentImpl(PodSpec instance) {
        this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
        this.withAffinity(instance.getAffinity());
        this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
        this.withContainers(instance.getContainers());
        this.withDnsConfig(instance.getDnsConfig());
        this.withDnsPolicy(instance.getDnsPolicy());
        this.withEnableServiceLinks(instance.getEnableServiceLinks());
        this.withHostAliases(instance.getHostAliases());
        this.withHostIPC(instance.getHostIPC());
        this.withHostNetwork(instance.getHostNetwork());
        this.withHostPID(instance.getHostPID());
        this.withHostname(instance.getHostname());
        this.withImagePullSecrets(instance.getImagePullSecrets());
        this.withInitContainers(instance.getInitContainers());
        this.withNodeName(instance.getNodeName());
        this.withNodeSelector(instance.getNodeSelector());
        this.withPriority(instance.getPriority());
        this.withPriorityClassName(instance.getPriorityClassName());
        this.withReadinessGates(instance.getReadinessGates());
        this.withRestartPolicy(instance.getRestartPolicy());
        this.withRuntimeClassName(instance.getRuntimeClassName());
        this.withSchedulerName(instance.getSchedulerName());
        this.withSecurityContext(instance.getSecurityContext());
        this.withServiceAccount(instance.getServiceAccount());
        this.withServiceAccountName(instance.getServiceAccountName());
        this.withShareProcessNamespace(instance.getShareProcessNamespace());
        this.withSubdomain(instance.getSubdomain());
        this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
        this.withTolerations(instance.getTolerations());
        this.withVolumes(instance.getVolumes());
    }

    @Override
    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    @Override
    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds != null;
    }

    @Override
    @Deprecated
    public Affinity getAffinity() {
        return this.affinity != null ? this.affinity.build() : null;
    }

    @Override
    public Affinity buildAffinity() {
        return this.affinity != null ? this.affinity.build() : null;
    }

    @Override
    public A withAffinity(Affinity affinity) {
        this._visitables.get("affinity").remove(this.affinity);
        if (affinity != null) {
            this.affinity = new AffinityBuilder(affinity);
            this._visitables.get("affinity").add(this.affinity);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAffinity() {
        return this.affinity != null;
    }

    @Override
    public PodSpecFluent.AffinityNested<A> withNewAffinity() {
        return new AffinityNestedImpl();
    }

    @Override
    public PodSpecFluent.AffinityNested<A> withNewAffinityLike(Affinity item) {
        return new AffinityNestedImpl(item);
    }

    @Override
    public PodSpecFluent.AffinityNested<A> editAffinity() {
        return this.withNewAffinityLike(this.getAffinity());
    }

    @Override
    public PodSpecFluent.AffinityNested<A> editOrNewAffinity() {
        return this.withNewAffinityLike(this.getAffinity() != null ? this.getAffinity() : new AffinityBuilder().build());
    }

    @Override
    public PodSpecFluent.AffinityNested<A> editOrNewAffinityLike(Affinity item) {
        return this.withNewAffinityLike(this.getAffinity() != null ? this.getAffinity() : item);
    }

    @Override
    public Boolean isAutomountServiceAccountToken() {
        return this.automountServiceAccountToken;
    }

    @Override
    public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken) {
        this.automountServiceAccountToken = automountServiceAccountToken;
        return (A)this;
    }

    @Override
    public Boolean hasAutomountServiceAccountToken() {
        return this.automountServiceAccountToken != null;
    }

    @Override
    public A withNewAutomountServiceAccountToken(String arg1) {
        return this.withAutomountServiceAccountToken(new Boolean(arg1));
    }

    @Override
    public A withNewAutomountServiceAccountToken(boolean arg1) {
        return this.withAutomountServiceAccountToken(new Boolean(arg1));
    }

    @Override
    public A addToContainers(int index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList<ContainerBuilder>();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        this._visitables.get("containers").add(index >= 0 ? index : this._visitables.get("containers").size(), builder);
        this.containers.add(index >= 0 ? index : this.containers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToContainers(int index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList<ContainerBuilder>();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this._visitables.get("containers").size()) {
            this._visitables.get("containers").add(builder);
        } else {
            this._visitables.get("containers").set(index, builder);
        }
        if (index < 0 || index >= this.containers.size()) {
            this.containers.add(builder);
        } else {
            this.containers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToContainers(Container ... items) {
        if (this.containers == null) {
            this.containers = new ArrayList<ContainerBuilder>();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToContainers(Collection<Container> items) {
        if (this.containers == null) {
            this.containers = new ArrayList<ContainerBuilder>();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainers(Container ... items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("containers").remove(builder);
            if (this.containers == null) continue;
            this.containers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContainers(Collection<Container> items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("containers").remove(builder);
            if (this.containers == null) continue;
            this.containers.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Container> getContainers() {
        return PodSpecFluentImpl.build(this.containers);
    }

    @Override
    public List<Container> buildContainers() {
        return PodSpecFluentImpl.build(this.containers);
    }

    @Override
    public Container buildContainer(int index) {
        return this.containers.get(index).build();
    }

    @Override
    public Container buildFirstContainer() {
        return this.containers.get(0).build();
    }

    @Override
    public Container buildLastContainer() {
        return this.containers.get(this.containers.size() - 1).build();
    }

    @Override
    public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.containers) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.containers) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withContainers(List<Container> containers) {
        if (this.containers != null) {
            this._visitables.get("containers").removeAll(this.containers);
        }
        if (containers != null) {
            this.containers = new ArrayList<ContainerBuilder>();
            for (Container item : containers) {
                this.addToContainers(item);
            }
        } else {
            this.containers = new ArrayList<ContainerBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withContainers(Container ... containers) {
        if (this.containers != null) {
            this.containers.clear();
        }
        if (containers != null) {
            for (Container item : containers) {
                this.addToContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContainers() {
        return this.containers != null && !this.containers.isEmpty();
    }

    @Override
    public PodSpecFluent.ContainersNested<A> addNewContainer() {
        return new ContainersNestedImpl();
    }

    @Override
    public PodSpecFluent.ContainersNested<A> addNewContainerLike(Container item) {
        return new ContainersNestedImpl(-1, item);
    }

    @Override
    public PodSpecFluent.ContainersNested<A> setNewContainerLike(int index, Container item) {
        return new ContainersNestedImpl(index, item);
    }

    @Override
    public PodSpecFluent.ContainersNested<A> editContainer(int index) {
        if (this.containers.size() <= index) {
            throw new RuntimeException("Can't edit containers. Index exceeds size.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public PodSpecFluent.ContainersNested<A> editFirstContainer() {
        if (this.containers.size() == 0) {
            throw new RuntimeException("Can't edit first containers. The list is empty.");
        }
        return this.setNewContainerLike(0, this.buildContainer(0));
    }

    @Override
    public PodSpecFluent.ContainersNested<A> editLastContainer() {
        int index = this.containers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containers. The list is empty.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public PodSpecFluent.ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containers.size(); ++i) {
            if (!predicate.apply(this.containers.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containers. No match found.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    @Deprecated
    public PodDNSConfig getDnsConfig() {
        return this.dnsConfig != null ? this.dnsConfig.build() : null;
    }

    @Override
    public PodDNSConfig buildDnsConfig() {
        return this.dnsConfig != null ? this.dnsConfig.build() : null;
    }

    @Override
    public A withDnsConfig(PodDNSConfig dnsConfig) {
        this._visitables.get("dnsConfig").remove(this.dnsConfig);
        if (dnsConfig != null) {
            this.dnsConfig = new PodDNSConfigBuilder(dnsConfig);
            this._visitables.get("dnsConfig").add(this.dnsConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDnsConfig() {
        return this.dnsConfig != null;
    }

    @Override
    public PodSpecFluent.DnsConfigNested<A> withNewDnsConfig() {
        return new DnsConfigNestedImpl();
    }

    @Override
    public PodSpecFluent.DnsConfigNested<A> withNewDnsConfigLike(PodDNSConfig item) {
        return new DnsConfigNestedImpl(item);
    }

    @Override
    public PodSpecFluent.DnsConfigNested<A> editDnsConfig() {
        return this.withNewDnsConfigLike(this.getDnsConfig());
    }

    @Override
    public PodSpecFluent.DnsConfigNested<A> editOrNewDnsConfig() {
        return this.withNewDnsConfigLike(this.getDnsConfig() != null ? this.getDnsConfig() : new PodDNSConfigBuilder().build());
    }

    @Override
    public PodSpecFluent.DnsConfigNested<A> editOrNewDnsConfigLike(PodDNSConfig item) {
        return this.withNewDnsConfigLike(this.getDnsConfig() != null ? this.getDnsConfig() : item);
    }

    @Override
    public String getDnsPolicy() {
        return this.dnsPolicy;
    }

    @Override
    public A withDnsPolicy(String dnsPolicy) {
        this.dnsPolicy = dnsPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasDnsPolicy() {
        return this.dnsPolicy != null;
    }

    @Override
    public A withNewDnsPolicy(String arg1) {
        return this.withDnsPolicy(new String(arg1));
    }

    @Override
    public A withNewDnsPolicy(StringBuilder arg1) {
        return this.withDnsPolicy(new String(arg1));
    }

    @Override
    public A withNewDnsPolicy(StringBuffer arg1) {
        return this.withDnsPolicy(new String(arg1));
    }

    @Override
    public Boolean isEnableServiceLinks() {
        return this.enableServiceLinks;
    }

    @Override
    public A withEnableServiceLinks(Boolean enableServiceLinks) {
        this.enableServiceLinks = enableServiceLinks;
        return (A)this;
    }

    @Override
    public Boolean hasEnableServiceLinks() {
        return this.enableServiceLinks != null;
    }

    @Override
    public A withNewEnableServiceLinks(String arg1) {
        return this.withEnableServiceLinks(new Boolean(arg1));
    }

    @Override
    public A withNewEnableServiceLinks(boolean arg1) {
        return this.withEnableServiceLinks(new Boolean(arg1));
    }

    @Override
    public A addToHostAliases(int index, HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAliasBuilder>();
        }
        HostAliasBuilder builder = new HostAliasBuilder(item);
        this._visitables.get("hostAliases").add(index >= 0 ? index : this._visitables.get("hostAliases").size(), builder);
        this.hostAliases.add(index >= 0 ? index : this.hostAliases.size(), builder);
        return (A)this;
    }

    @Override
    public A setToHostAliases(int index, HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAliasBuilder>();
        }
        HostAliasBuilder builder = new HostAliasBuilder(item);
        if (index < 0 || index >= this._visitables.get("hostAliases").size()) {
            this._visitables.get("hostAliases").add(builder);
        } else {
            this._visitables.get("hostAliases").set(index, builder);
        }
        if (index < 0 || index >= this.hostAliases.size()) {
            this.hostAliases.add(builder);
        } else {
            this.hostAliases.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToHostAliases(HostAlias ... items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAliasBuilder>();
        }
        for (HostAlias item : items) {
            HostAliasBuilder builder = new HostAliasBuilder(item);
            this._visitables.get("hostAliases").add(builder);
            this.hostAliases.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToHostAliases(Collection<HostAlias> items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAliasBuilder>();
        }
        for (HostAlias item : items) {
            HostAliasBuilder builder = new HostAliasBuilder(item);
            this._visitables.get("hostAliases").add(builder);
            this.hostAliases.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromHostAliases(HostAlias ... items) {
        for (HostAlias item : items) {
            HostAliasBuilder builder = new HostAliasBuilder(item);
            this._visitables.get("hostAliases").remove(builder);
            if (this.hostAliases == null) continue;
            this.hostAliases.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHostAliases(Collection<HostAlias> items) {
        for (HostAlias item : items) {
            HostAliasBuilder builder = new HostAliasBuilder(item);
            this._visitables.get("hostAliases").remove(builder);
            if (this.hostAliases == null) continue;
            this.hostAliases.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<HostAlias> getHostAliases() {
        return PodSpecFluentImpl.build(this.hostAliases);
    }

    @Override
    public List<HostAlias> buildHostAliases() {
        return PodSpecFluentImpl.build(this.hostAliases);
    }

    @Override
    public HostAlias buildHostAlias(int index) {
        return this.hostAliases.get(index).build();
    }

    @Override
    public HostAlias buildFirstHostAlias() {
        return this.hostAliases.get(0).build();
    }

    @Override
    public HostAlias buildLastHostAlias() {
        return this.hostAliases.get(this.hostAliases.size() - 1).build();
    }

    @Override
    public HostAlias buildMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
        for (HostAliasBuilder item : this.hostAliases) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
        for (HostAliasBuilder item : this.hostAliases) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHostAliases(List<HostAlias> hostAliases) {
        if (this.hostAliases != null) {
            this._visitables.get("hostAliases").removeAll(this.hostAliases);
        }
        if (hostAliases != null) {
            this.hostAliases = new ArrayList<HostAliasBuilder>();
            for (HostAlias item : hostAliases) {
                this.addToHostAliases(item);
            }
        } else {
            this.hostAliases = new ArrayList<HostAliasBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withHostAliases(HostAlias ... hostAliases) {
        if (this.hostAliases != null) {
            this.hostAliases.clear();
        }
        if (hostAliases != null) {
            for (HostAlias item : hostAliases) {
                this.addToHostAliases(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHostAliases() {
        return this.hostAliases != null && !this.hostAliases.isEmpty();
    }

    @Override
    public PodSpecFluent.HostAliasesNested<A> addNewHostAlias() {
        return new HostAliasesNestedImpl();
    }

    @Override
    public PodSpecFluent.HostAliasesNested<A> addNewHostAliasLike(HostAlias item) {
        return new HostAliasesNestedImpl(-1, item);
    }

    @Override
    public PodSpecFluent.HostAliasesNested<A> setNewHostAliasLike(int index, HostAlias item) {
        return new HostAliasesNestedImpl(index, item);
    }

    @Override
    public PodSpecFluent.HostAliasesNested<A> editHostAlias(int index) {
        if (this.hostAliases.size() <= index) {
            throw new RuntimeException("Can't edit hostAliases. Index exceeds size.");
        }
        return this.setNewHostAliasLike(index, this.buildHostAlias(index));
    }

    @Override
    public PodSpecFluent.HostAliasesNested<A> editFirstHostAlias() {
        if (this.hostAliases.size() == 0) {
            throw new RuntimeException("Can't edit first hostAliases. The list is empty.");
        }
        return this.setNewHostAliasLike(0, this.buildHostAlias(0));
    }

    @Override
    public PodSpecFluent.HostAliasesNested<A> editLastHostAlias() {
        int index = this.hostAliases.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last hostAliases. The list is empty.");
        }
        return this.setNewHostAliasLike(index, this.buildHostAlias(index));
    }

    @Override
    public PodSpecFluent.HostAliasesNested<A> editMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.hostAliases.size(); ++i) {
            if (!predicate.apply(this.hostAliases.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching hostAliases. No match found.");
        }
        return this.setNewHostAliasLike(index, this.buildHostAlias(index));
    }

    @Override
    public Boolean isHostIPC() {
        return this.hostIPC;
    }

    @Override
    public A withHostIPC(Boolean hostIPC) {
        this.hostIPC = hostIPC;
        return (A)this;
    }

    @Override
    public Boolean hasHostIPC() {
        return this.hostIPC != null;
    }

    @Override
    public A withNewHostIPC(String arg1) {
        return this.withHostIPC(new Boolean(arg1));
    }

    @Override
    public A withNewHostIPC(boolean arg1) {
        return this.withHostIPC(new Boolean(arg1));
    }

    @Override
    public Boolean isHostNetwork() {
        return this.hostNetwork;
    }

    @Override
    public A withHostNetwork(Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
        return (A)this;
    }

    @Override
    public Boolean hasHostNetwork() {
        return this.hostNetwork != null;
    }

    @Override
    public A withNewHostNetwork(String arg1) {
        return this.withHostNetwork(new Boolean(arg1));
    }

    @Override
    public A withNewHostNetwork(boolean arg1) {
        return this.withHostNetwork(new Boolean(arg1));
    }

    @Override
    public Boolean isHostPID() {
        return this.hostPID;
    }

    @Override
    public A withHostPID(Boolean hostPID) {
        this.hostPID = hostPID;
        return (A)this;
    }

    @Override
    public Boolean hasHostPID() {
        return this.hostPID != null;
    }

    @Override
    public A withNewHostPID(String arg1) {
        return this.withHostPID(new Boolean(arg1));
    }

    @Override
    public A withNewHostPID(boolean arg1) {
        return this.withHostPID(new Boolean(arg1));
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    @Override
    public Boolean hasHostname() {
        return this.hostname != null;
    }

    @Override
    public A withNewHostname(String arg1) {
        return this.withHostname(new String(arg1));
    }

    @Override
    public A withNewHostname(StringBuilder arg1) {
        return this.withHostname(new String(arg1));
    }

    @Override
    public A withNewHostname(StringBuffer arg1) {
        return this.withHostname(new String(arg1));
    }

    @Override
    public A addToImagePullSecrets(int index, LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();
        }
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        this._visitables.get("imagePullSecrets").add(index >= 0 ? index : this._visitables.get("imagePullSecrets").size(), builder);
        this.imagePullSecrets.add(index >= 0 ? index : this.imagePullSecrets.size(), builder);
        return (A)this;
    }

    @Override
    public A setToImagePullSecrets(int index, LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();
        }
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this._visitables.get("imagePullSecrets").size()) {
            this._visitables.get("imagePullSecrets").add(builder);
        } else {
            this._visitables.get("imagePullSecrets").set(index, builder);
        }
        if (index < 0 || index >= this.imagePullSecrets.size()) {
            this.imagePullSecrets.add(builder);
        } else {
            this.imagePullSecrets.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToImagePullSecrets(LocalObjectReference ... items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToImagePullSecrets(Collection<LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromImagePullSecrets(LocalObjectReference ... items) {
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").remove(builder);
            if (this.imagePullSecrets == null) continue;
            this.imagePullSecrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items) {
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").remove(builder);
            if (this.imagePullSecrets == null) continue;
            this.imagePullSecrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<LocalObjectReference> getImagePullSecrets() {
        return PodSpecFluentImpl.build(this.imagePullSecrets);
    }

    @Override
    public List<LocalObjectReference> buildImagePullSecrets() {
        return PodSpecFluentImpl.build(this.imagePullSecrets);
    }

    @Override
    public LocalObjectReference buildImagePullSecret(int index) {
        return this.imagePullSecrets.get(index).build();
    }

    @Override
    public LocalObjectReference buildFirstImagePullSecret() {
        return this.imagePullSecrets.get(0).build();
    }

    @Override
    public LocalObjectReference buildLastImagePullSecret() {
        return this.imagePullSecrets.get(this.imagePullSecrets.size() - 1).build();
    }

    @Override
    public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this._visitables.get("imagePullSecrets").removeAll(this.imagePullSecrets);
        }
        if (imagePullSecrets != null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        } else {
            this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withImagePullSecrets(LocalObjectReference ... imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this.imagePullSecrets.clear();
        }
        if (imagePullSecrets != null) {
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasImagePullSecrets() {
        return this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty();
    }

    @Override
    public A addNewImagePullSecret(String name) {
        return this.addToImagePullSecrets(new LocalObjectReference(name));
    }

    @Override
    public PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecret() {
        return new ImagePullSecretsNestedImpl();
    }

    @Override
    public PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item) {
        return new ImagePullSecretsNestedImpl(-1, item);
    }

    @Override
    public PodSpecFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(int index, LocalObjectReference item) {
        return new ImagePullSecretsNestedImpl(index, item);
    }

    @Override
    public PodSpecFluent.ImagePullSecretsNested<A> editImagePullSecret(int index) {
        if (this.imagePullSecrets.size() <= index) {
            throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    @Override
    public PodSpecFluent.ImagePullSecretsNested<A> editFirstImagePullSecret() {
        if (this.imagePullSecrets.size() == 0) {
            throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(0, this.buildImagePullSecret(0));
    }

    @Override
    public PodSpecFluent.ImagePullSecretsNested<A> editLastImagePullSecret() {
        int index = this.imagePullSecrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    @Override
    public PodSpecFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.imagePullSecrets.size(); ++i) {
            if (!predicate.apply(this.imagePullSecrets.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    @Override
    public A addToInitContainers(int index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList<ContainerBuilder>();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        this._visitables.get("initContainers").add(index >= 0 ? index : this._visitables.get("initContainers").size(), builder);
        this.initContainers.add(index >= 0 ? index : this.initContainers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToInitContainers(int index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList<ContainerBuilder>();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this._visitables.get("initContainers").size()) {
            this._visitables.get("initContainers").add(builder);
        } else {
            this._visitables.get("initContainers").set(index, builder);
        }
        if (index < 0 || index >= this.initContainers.size()) {
            this.initContainers.add(builder);
        } else {
            this.initContainers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToInitContainers(Container ... items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList<ContainerBuilder>();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToInitContainers(Collection<Container> items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList<ContainerBuilder>();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromInitContainers(Container ... items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("initContainers").remove(builder);
            if (this.initContainers == null) continue;
            this.initContainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromInitContainers(Collection<Container> items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("initContainers").remove(builder);
            if (this.initContainers == null) continue;
            this.initContainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Container> getInitContainers() {
        return PodSpecFluentImpl.build(this.initContainers);
    }

    @Override
    public List<Container> buildInitContainers() {
        return PodSpecFluentImpl.build(this.initContainers);
    }

    @Override
    public Container buildInitContainer(int index) {
        return this.initContainers.get(index).build();
    }

    @Override
    public Container buildFirstInitContainer() {
        return this.initContainers.get(0).build();
    }

    @Override
    public Container buildLastInitContainer() {
        return this.initContainers.get(this.initContainers.size() - 1).build();
    }

    @Override
    public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.initContainers) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.initContainers) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withInitContainers(List<Container> initContainers) {
        if (this.initContainers != null) {
            this._visitables.get("initContainers").removeAll(this.initContainers);
        }
        if (initContainers != null) {
            this.initContainers = new ArrayList<ContainerBuilder>();
            for (Container item : initContainers) {
                this.addToInitContainers(item);
            }
        } else {
            this.initContainers = new ArrayList<ContainerBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withInitContainers(Container ... initContainers) {
        if (this.initContainers != null) {
            this.initContainers.clear();
        }
        if (initContainers != null) {
            for (Container item : initContainers) {
                this.addToInitContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasInitContainers() {
        return this.initContainers != null && !this.initContainers.isEmpty();
    }

    @Override
    public PodSpecFluent.InitContainersNested<A> addNewInitContainer() {
        return new InitContainersNestedImpl();
    }

    @Override
    public PodSpecFluent.InitContainersNested<A> addNewInitContainerLike(Container item) {
        return new InitContainersNestedImpl(-1, item);
    }

    @Override
    public PodSpecFluent.InitContainersNested<A> setNewInitContainerLike(int index, Container item) {
        return new InitContainersNestedImpl(index, item);
    }

    @Override
    public PodSpecFluent.InitContainersNested<A> editInitContainer(int index) {
        if (this.initContainers.size() <= index) {
            throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public PodSpecFluent.InitContainersNested<A> editFirstInitContainer() {
        if (this.initContainers.size() == 0) {
            throw new RuntimeException("Can't edit first initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(0, this.buildInitContainer(0));
    }

    @Override
    public PodSpecFluent.InitContainersNested<A> editLastInitContainer() {
        int index = this.initContainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public PodSpecFluent.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.initContainers.size(); ++i) {
            if (!predicate.apply(this.initContainers.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching initContainers. No match found.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)this;
    }

    @Override
    public Boolean hasNodeName() {
        return this.nodeName != null;
    }

    @Override
    public A withNewNodeName(String arg1) {
        return this.withNodeName(new String(arg1));
    }

    @Override
    public A withNewNodeName(StringBuilder arg1) {
        return this.withNodeName(new String(arg1));
    }

    @Override
    public A withNewNodeName(StringBuffer arg1) {
        return this.withNodeName(new String(arg1));
    }

    @Override
    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    @Override
    public A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? new LinkedHashMap<String, String>() : new LinkedHashMap<String, String>(nodeSelector);
        return (A)this;
    }

    @Override
    public Boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    @Override
    public Integer getPriority() {
        return this.priority;
    }

    @Override
    public A withPriority(Integer priority) {
        this.priority = priority;
        return (A)this;
    }

    @Override
    public Boolean hasPriority() {
        return this.priority != null;
    }

    @Override
    public String getPriorityClassName() {
        return this.priorityClassName;
    }

    @Override
    public A withPriorityClassName(String priorityClassName) {
        this.priorityClassName = priorityClassName;
        return (A)this;
    }

    @Override
    public Boolean hasPriorityClassName() {
        return this.priorityClassName != null;
    }

    @Override
    public A withNewPriorityClassName(String arg1) {
        return this.withPriorityClassName(new String(arg1));
    }

    @Override
    public A withNewPriorityClassName(StringBuilder arg1) {
        return this.withPriorityClassName(new String(arg1));
    }

    @Override
    public A withNewPriorityClassName(StringBuffer arg1) {
        return this.withPriorityClassName(new String(arg1));
    }

    @Override
    public A addToReadinessGates(int index, PodReadinessGate item) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList<PodReadinessGateBuilder>();
        }
        PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);
        this._visitables.get("readinessGates").add(index >= 0 ? index : this._visitables.get("readinessGates").size(), builder);
        this.readinessGates.add(index >= 0 ? index : this.readinessGates.size(), builder);
        return (A)this;
    }

    @Override
    public A setToReadinessGates(int index, PodReadinessGate item) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList<PodReadinessGateBuilder>();
        }
        PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);
        if (index < 0 || index >= this._visitables.get("readinessGates").size()) {
            this._visitables.get("readinessGates").add(builder);
        } else {
            this._visitables.get("readinessGates").set(index, builder);
        }
        if (index < 0 || index >= this.readinessGates.size()) {
            this.readinessGates.add(builder);
        } else {
            this.readinessGates.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToReadinessGates(PodReadinessGate ... items) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList<PodReadinessGateBuilder>();
        }
        for (PodReadinessGate item : items) {
            PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);
            this._visitables.get("readinessGates").add(builder);
            this.readinessGates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToReadinessGates(Collection<PodReadinessGate> items) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList<PodReadinessGateBuilder>();
        }
        for (PodReadinessGate item : items) {
            PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);
            this._visitables.get("readinessGates").add(builder);
            this.readinessGates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromReadinessGates(PodReadinessGate ... items) {
        for (PodReadinessGate item : items) {
            PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);
            this._visitables.get("readinessGates").remove(builder);
            if (this.readinessGates == null) continue;
            this.readinessGates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromReadinessGates(Collection<PodReadinessGate> items) {
        for (PodReadinessGate item : items) {
            PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);
            this._visitables.get("readinessGates").remove(builder);
            if (this.readinessGates == null) continue;
            this.readinessGates.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PodReadinessGate> getReadinessGates() {
        return PodSpecFluentImpl.build(this.readinessGates);
    }

    @Override
    public List<PodReadinessGate> buildReadinessGates() {
        return PodSpecFluentImpl.build(this.readinessGates);
    }

    @Override
    public PodReadinessGate buildReadinessGate(int index) {
        return this.readinessGates.get(index).build();
    }

    @Override
    public PodReadinessGate buildFirstReadinessGate() {
        return this.readinessGates.get(0).build();
    }

    @Override
    public PodReadinessGate buildLastReadinessGate() {
        return this.readinessGates.get(this.readinessGates.size() - 1).build();
    }

    @Override
    public PodReadinessGate buildMatchingReadinessGate(Predicate<PodReadinessGateBuilder> predicate) {
        for (PodReadinessGateBuilder item : this.readinessGates) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingReadinessGate(Predicate<PodReadinessGateBuilder> predicate) {
        for (PodReadinessGateBuilder item : this.readinessGates) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withReadinessGates(List<PodReadinessGate> readinessGates) {
        if (this.readinessGates != null) {
            this._visitables.get("readinessGates").removeAll(this.readinessGates);
        }
        if (readinessGates != null) {
            this.readinessGates = new ArrayList<PodReadinessGateBuilder>();
            for (PodReadinessGate item : readinessGates) {
                this.addToReadinessGates(item);
            }
        } else {
            this.readinessGates = new ArrayList<PodReadinessGateBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withReadinessGates(PodReadinessGate ... readinessGates) {
        if (this.readinessGates != null) {
            this.readinessGates.clear();
        }
        if (readinessGates != null) {
            for (PodReadinessGate item : readinessGates) {
                this.addToReadinessGates(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasReadinessGates() {
        return this.readinessGates != null && !this.readinessGates.isEmpty();
    }

    @Override
    public A addNewReadinessGate(String conditionType) {
        return this.addToReadinessGates(new PodReadinessGate(conditionType));
    }

    @Override
    public PodSpecFluent.ReadinessGatesNested<A> addNewReadinessGate() {
        return new ReadinessGatesNestedImpl();
    }

    @Override
    public PodSpecFluent.ReadinessGatesNested<A> addNewReadinessGateLike(PodReadinessGate item) {
        return new ReadinessGatesNestedImpl(-1, item);
    }

    @Override
    public PodSpecFluent.ReadinessGatesNested<A> setNewReadinessGateLike(int index, PodReadinessGate item) {
        return new ReadinessGatesNestedImpl(index, item);
    }

    @Override
    public PodSpecFluent.ReadinessGatesNested<A> editReadinessGate(int index) {
        if (this.readinessGates.size() <= index) {
            throw new RuntimeException("Can't edit readinessGates. Index exceeds size.");
        }
        return this.setNewReadinessGateLike(index, this.buildReadinessGate(index));
    }

    @Override
    public PodSpecFluent.ReadinessGatesNested<A> editFirstReadinessGate() {
        if (this.readinessGates.size() == 0) {
            throw new RuntimeException("Can't edit first readinessGates. The list is empty.");
        }
        return this.setNewReadinessGateLike(0, this.buildReadinessGate(0));
    }

    @Override
    public PodSpecFluent.ReadinessGatesNested<A> editLastReadinessGate() {
        int index = this.readinessGates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last readinessGates. The list is empty.");
        }
        return this.setNewReadinessGateLike(index, this.buildReadinessGate(index));
    }

    @Override
    public PodSpecFluent.ReadinessGatesNested<A> editMatchingReadinessGate(Predicate<PodReadinessGateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.readinessGates.size(); ++i) {
            if (!predicate.apply(this.readinessGates.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching readinessGates. No match found.");
        }
        return this.setNewReadinessGateLike(index, this.buildReadinessGate(index));
    }

    @Override
    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    @Override
    public A withRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasRestartPolicy() {
        return this.restartPolicy != null;
    }

    @Override
    public A withNewRestartPolicy(String arg1) {
        return this.withRestartPolicy(new String(arg1));
    }

    @Override
    public A withNewRestartPolicy(StringBuilder arg1) {
        return this.withRestartPolicy(new String(arg1));
    }

    @Override
    public A withNewRestartPolicy(StringBuffer arg1) {
        return this.withRestartPolicy(new String(arg1));
    }

    @Override
    public String getRuntimeClassName() {
        return this.runtimeClassName;
    }

    @Override
    public A withRuntimeClassName(String runtimeClassName) {
        this.runtimeClassName = runtimeClassName;
        return (A)this;
    }

    @Override
    public Boolean hasRuntimeClassName() {
        return this.runtimeClassName != null;
    }

    @Override
    public A withNewRuntimeClassName(String arg1) {
        return this.withRuntimeClassName(new String(arg1));
    }

    @Override
    public A withNewRuntimeClassName(StringBuilder arg1) {
        return this.withRuntimeClassName(new String(arg1));
    }

    @Override
    public A withNewRuntimeClassName(StringBuffer arg1) {
        return this.withRuntimeClassName(new String(arg1));
    }

    @Override
    public String getSchedulerName() {
        return this.schedulerName;
    }

    @Override
    public A withSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
        return (A)this;
    }

    @Override
    public Boolean hasSchedulerName() {
        return this.schedulerName != null;
    }

    @Override
    public A withNewSchedulerName(String arg1) {
        return this.withSchedulerName(new String(arg1));
    }

    @Override
    public A withNewSchedulerName(StringBuilder arg1) {
        return this.withSchedulerName(new String(arg1));
    }

    @Override
    public A withNewSchedulerName(StringBuffer arg1) {
        return this.withSchedulerName(new String(arg1));
    }

    @Override
    @Deprecated
    public PodSecurityContext getSecurityContext() {
        return this.securityContext != null ? this.securityContext.build() : null;
    }

    @Override
    public PodSecurityContext buildSecurityContext() {
        return this.securityContext != null ? this.securityContext.build() : null;
    }

    @Override
    public A withSecurityContext(PodSecurityContext securityContext) {
        this._visitables.get("securityContext").remove(this.securityContext);
        if (securityContext != null) {
            this.securityContext = new PodSecurityContextBuilder(securityContext);
            this._visitables.get("securityContext").add(this.securityContext);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    @Override
    public PodSpecFluent.SecurityContextNested<A> withNewSecurityContext() {
        return new SecurityContextNestedImpl();
    }

    @Override
    public PodSpecFluent.SecurityContextNested<A> withNewSecurityContextLike(PodSecurityContext item) {
        return new SecurityContextNestedImpl(item);
    }

    @Override
    public PodSpecFluent.SecurityContextNested<A> editSecurityContext() {
        return this.withNewSecurityContextLike(this.getSecurityContext());
    }

    @Override
    public PodSpecFluent.SecurityContextNested<A> editOrNewSecurityContext() {
        return this.withNewSecurityContextLike(this.getSecurityContext() != null ? this.getSecurityContext() : new PodSecurityContextBuilder().build());
    }

    @Override
    public PodSpecFluent.SecurityContextNested<A> editOrNewSecurityContextLike(PodSecurityContext item) {
        return this.withNewSecurityContextLike(this.getSecurityContext() != null ? this.getSecurityContext() : item);
    }

    @Override
    public String getServiceAccount() {
        return this.serviceAccount;
    }

    @Override
    public A withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    @Override
    public A withNewServiceAccount(String arg1) {
        return this.withServiceAccount(new String(arg1));
    }

    @Override
    public A withNewServiceAccount(StringBuilder arg1) {
        return this.withServiceAccount(new String(arg1));
    }

    @Override
    public A withNewServiceAccount(StringBuffer arg1) {
        return this.withServiceAccount(new String(arg1));
    }

    @Override
    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    @Override
    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    @Override
    public A withNewServiceAccountName(String arg1) {
        return this.withServiceAccountName(new String(arg1));
    }

    @Override
    public A withNewServiceAccountName(StringBuilder arg1) {
        return this.withServiceAccountName(new String(arg1));
    }

    @Override
    public A withNewServiceAccountName(StringBuffer arg1) {
        return this.withServiceAccountName(new String(arg1));
    }

    @Override
    public Boolean isShareProcessNamespace() {
        return this.shareProcessNamespace;
    }

    @Override
    public A withShareProcessNamespace(Boolean shareProcessNamespace) {
        this.shareProcessNamespace = shareProcessNamespace;
        return (A)this;
    }

    @Override
    public Boolean hasShareProcessNamespace() {
        return this.shareProcessNamespace != null;
    }

    @Override
    public A withNewShareProcessNamespace(String arg1) {
        return this.withShareProcessNamespace(new Boolean(arg1));
    }

    @Override
    public A withNewShareProcessNamespace(boolean arg1) {
        return this.withShareProcessNamespace(new Boolean(arg1));
    }

    @Override
    public String getSubdomain() {
        return this.subdomain;
    }

    @Override
    public A withSubdomain(String subdomain) {
        this.subdomain = subdomain;
        return (A)this;
    }

    @Override
    public Boolean hasSubdomain() {
        return this.subdomain != null;
    }

    @Override
    public A withNewSubdomain(String arg1) {
        return this.withSubdomain(new String(arg1));
    }

    @Override
    public A withNewSubdomain(StringBuilder arg1) {
        return this.withSubdomain(new String(arg1));
    }

    @Override
    public A withNewSubdomain(StringBuffer arg1) {
        return this.withSubdomain(new String(arg1));
    }

    @Override
    public Long getTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    @Override
    public A withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds != null;
    }

    @Override
    public A addToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<TolerationBuilder>();
        }
        TolerationBuilder builder = new TolerationBuilder(item);
        this._visitables.get("tolerations").add(index >= 0 ? index : this._visitables.get("tolerations").size(), builder);
        this.tolerations.add(index >= 0 ? index : this.tolerations.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<TolerationBuilder>();
        }
        TolerationBuilder builder = new TolerationBuilder(item);
        if (index < 0 || index >= this._visitables.get("tolerations").size()) {
            this._visitables.get("tolerations").add(builder);
        } else {
            this._visitables.get("tolerations").set(index, builder);
        }
        if (index < 0 || index >= this.tolerations.size()) {
            this.tolerations.add(builder);
        } else {
            this.tolerations.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<TolerationBuilder>();
        }
        for (Toleration item : items) {
            TolerationBuilder builder = new TolerationBuilder(item);
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<TolerationBuilder>();
        }
        for (Toleration item : items) {
            TolerationBuilder builder = new TolerationBuilder(item);
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTolerations(Toleration ... items) {
        for (Toleration item : items) {
            TolerationBuilder builder = new TolerationBuilder(item);
            this._visitables.get("tolerations").remove(builder);
            if (this.tolerations == null) continue;
            this.tolerations.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {
            TolerationBuilder builder = new TolerationBuilder(item);
            this._visitables.get("tolerations").remove(builder);
            if (this.tolerations == null) continue;
            this.tolerations.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Toleration> getTolerations() {
        return PodSpecFluentImpl.build(this.tolerations);
    }

    @Override
    public List<Toleration> buildTolerations() {
        return PodSpecFluentImpl.build(this.tolerations);
    }

    @Override
    public Toleration buildToleration(int index) {
        return this.tolerations.get(index).build();
    }

    @Override
    public Toleration buildFirstToleration() {
        return this.tolerations.get(0).build();
    }

    @Override
    public Toleration buildLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1).build();
    }

    @Override
    public Toleration buildMatchingToleration(Predicate<TolerationBuilder> predicate) {
        for (TolerationBuilder item : this.tolerations) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingToleration(Predicate<TolerationBuilder> predicate) {
        for (TolerationBuilder item : this.tolerations) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTolerations(List<Toleration> tolerations) {
        if (this.tolerations != null) {
            this._visitables.get("tolerations").removeAll(this.tolerations);
        }
        if (tolerations != null) {
            this.tolerations = new ArrayList<TolerationBuilder>();
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = new ArrayList<TolerationBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withTolerations(Toleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
        }
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    @Override
    public A addNewToleration(String effect, String key, String operator, Long tolerationSeconds, String value) {
        return this.addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    @Override
    public PodSpecFluent.TolerationsNested<A> addNewToleration() {
        return new TolerationsNestedImpl();
    }

    @Override
    public PodSpecFluent.TolerationsNested<A> addNewTolerationLike(Toleration item) {
        return new TolerationsNestedImpl(-1, item);
    }

    @Override
    public PodSpecFluent.TolerationsNested<A> setNewTolerationLike(int index, Toleration item) {
        return new TolerationsNestedImpl(index, item);
    }

    @Override
    public PodSpecFluent.TolerationsNested<A> editToleration(int index) {
        if (this.tolerations.size() <= index) {
            throw new RuntimeException("Can't edit tolerations. Index exceeds size.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    @Override
    public PodSpecFluent.TolerationsNested<A> editFirstToleration() {
        if (this.tolerations.size() == 0) {
            throw new RuntimeException("Can't edit first tolerations. The list is empty.");
        }
        return this.setNewTolerationLike(0, this.buildToleration(0));
    }

    @Override
    public PodSpecFluent.TolerationsNested<A> editLastToleration() {
        int index = this.tolerations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tolerations. The list is empty.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    @Override
    public PodSpecFluent.TolerationsNested<A> editMatchingToleration(Predicate<TolerationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tolerations.size(); ++i) {
            if (!predicate.apply(this.tolerations.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tolerations. No match found.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    @Override
    public A addToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<VolumeBuilder>();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        this._visitables.get("volumes").add(index >= 0 ? index : this._visitables.get("volumes").size(), builder);
        this.volumes.add(index >= 0 ? index : this.volumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<VolumeBuilder>();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get("volumes").size()) {
            this._visitables.get("volumes").add(builder);
        } else {
            this._visitables.get("volumes").set(index, builder);
        }
        if (index < 0 || index >= this.volumes.size()) {
            this.volumes.add(builder);
        } else {
            this.volumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumes(Volume ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<VolumeBuilder>();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get("volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<VolumeBuilder>();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get("volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(Volume ... items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get("volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<Volume> items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get("volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Volume> getVolumes() {
        return PodSpecFluentImpl.build(this.volumes);
    }

    @Override
    public List<Volume> buildVolumes() {
        return PodSpecFluentImpl.build(this.volumes);
    }

    @Override
    public Volume buildVolume(int index) {
        return this.volumes.get(index).build();
    }

    @Override
    public Volume buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    @Override
    public Volume buildLastVolume() {
        return this.volumes.get(this.volumes.size() - 1).build();
    }

    @Override
    public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) {
            this._visitables.get("volumes").removeAll(this.volumes);
        }
        if (volumes != null) {
            this.volumes = new ArrayList<VolumeBuilder>();
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = new ArrayList<VolumeBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withVolumes(Volume ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
        }
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    @Override
    public PodSpecFluent.VolumesNested<A> addNewVolume() {
        return new VolumesNestedImpl();
    }

    @Override
    public PodSpecFluent.VolumesNested<A> addNewVolumeLike(Volume item) {
        return new VolumesNestedImpl(-1, item);
    }

    @Override
    public PodSpecFluent.VolumesNested<A> setNewVolumeLike(int index, Volume item) {
        return new VolumesNestedImpl(index, item);
    }

    @Override
    public PodSpecFluent.VolumesNested<A> editVolume(int index) {
        if (this.volumes.size() <= index) {
            throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public PodSpecFluent.VolumesNested<A> editFirstVolume() {
        if (this.volumes.size() == 0) {
            throw new RuntimeException("Can't edit first volumes. The list is empty.");
        }
        return this.setNewVolumeLike(0, this.buildVolume(0));
    }

    @Override
    public PodSpecFluent.VolumesNested<A> editLastVolume() {
        int index = this.volumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumes. The list is empty.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public PodSpecFluent.VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumes.size(); ++i) {
            if (!predicate.apply(this.volumes.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumes. No match found.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodSpecFluentImpl that = (PodSpecFluentImpl)o;
        if (this.activeDeadlineSeconds != null ? !this.activeDeadlineSeconds.equals(that.activeDeadlineSeconds) : that.activeDeadlineSeconds != null) {
            return false;
        }
        if (this.affinity != null ? !this.affinity.equals(that.affinity) : that.affinity != null) {
            return false;
        }
        if (this.automountServiceAccountToken != null ? !this.automountServiceAccountToken.equals(that.automountServiceAccountToken) : that.automountServiceAccountToken != null) {
            return false;
        }
        if (this.containers != null ? !this.containers.equals(that.containers) : that.containers != null) {
            return false;
        }
        if (this.dnsConfig != null ? !this.dnsConfig.equals(that.dnsConfig) : that.dnsConfig != null) {
            return false;
        }
        if (this.dnsPolicy != null ? !this.dnsPolicy.equals(that.dnsPolicy) : that.dnsPolicy != null) {
            return false;
        }
        if (this.enableServiceLinks != null ? !this.enableServiceLinks.equals(that.enableServiceLinks) : that.enableServiceLinks != null) {
            return false;
        }
        if (this.hostAliases != null ? !this.hostAliases.equals(that.hostAliases) : that.hostAliases != null) {
            return false;
        }
        if (this.hostIPC != null ? !this.hostIPC.equals(that.hostIPC) : that.hostIPC != null) {
            return false;
        }
        if (this.hostNetwork != null ? !this.hostNetwork.equals(that.hostNetwork) : that.hostNetwork != null) {
            return false;
        }
        if (this.hostPID != null ? !this.hostPID.equals(that.hostPID) : that.hostPID != null) {
            return false;
        }
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.imagePullSecrets != null ? !this.imagePullSecrets.equals(that.imagePullSecrets) : that.imagePullSecrets != null) {
            return false;
        }
        if (this.initContainers != null ? !this.initContainers.equals(that.initContainers) : that.initContainers != null) {
            return false;
        }
        if (this.nodeName != null ? !this.nodeName.equals(that.nodeName) : that.nodeName != null) {
            return false;
        }
        if (this.nodeSelector != null ? !this.nodeSelector.equals(that.nodeSelector) : that.nodeSelector != null) {
            return false;
        }
        if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) {
            return false;
        }
        if (this.priorityClassName != null ? !this.priorityClassName.equals(that.priorityClassName) : that.priorityClassName != null) {
            return false;
        }
        if (this.readinessGates != null ? !this.readinessGates.equals(that.readinessGates) : that.readinessGates != null) {
            return false;
        }
        if (this.restartPolicy != null ? !this.restartPolicy.equals(that.restartPolicy) : that.restartPolicy != null) {
            return false;
        }
        if (this.runtimeClassName != null ? !this.runtimeClassName.equals(that.runtimeClassName) : that.runtimeClassName != null) {
            return false;
        }
        if (this.schedulerName != null ? !this.schedulerName.equals(that.schedulerName) : that.schedulerName != null) {
            return false;
        }
        if (this.securityContext != null ? !this.securityContext.equals(that.securityContext) : that.securityContext != null) {
            return false;
        }
        if (this.serviceAccount != null ? !this.serviceAccount.equals(that.serviceAccount) : that.serviceAccount != null) {
            return false;
        }
        if (this.serviceAccountName != null ? !this.serviceAccountName.equals(that.serviceAccountName) : that.serviceAccountName != null) {
            return false;
        }
        if (this.shareProcessNamespace != null ? !this.shareProcessNamespace.equals(that.shareProcessNamespace) : that.shareProcessNamespace != null) {
            return false;
        }
        if (this.subdomain != null ? !this.subdomain.equals(that.subdomain) : that.subdomain != null) {
            return false;
        }
        if (this.terminationGracePeriodSeconds != null ? !this.terminationGracePeriodSeconds.equals(that.terminationGracePeriodSeconds) : that.terminationGracePeriodSeconds != null) {
            return false;
        }
        if (this.tolerations != null ? !this.tolerations.equals(that.tolerations) : that.tolerations != null) {
            return false;
        }
        return !(this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null);
    }

    public class VolumesNestedImpl<N>
    extends VolumeFluentImpl<PodSpecFluent.VolumesNested<N>>
    implements PodSpecFluent.VolumesNested<N>,
    Nested<N> {
        private final VolumeBuilder builder;
        private final int index;

        VolumesNestedImpl(int index, Volume item) {
            this.index = index;
            this.builder = new VolumeBuilder(this, item);
        }

        VolumesNestedImpl() {
            this.index = -1;
            this.builder = new VolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.setToVolumes(this.index, this.builder.build());
        }

        @Override
        public N endVolume() {
            return this.and();
        }
    }

    public class TolerationsNestedImpl<N>
    extends TolerationFluentImpl<PodSpecFluent.TolerationsNested<N>>
    implements PodSpecFluent.TolerationsNested<N>,
    Nested<N> {
        private final TolerationBuilder builder;
        private final int index;

        TolerationsNestedImpl(int index, Toleration item) {
            this.index = index;
            this.builder = new TolerationBuilder(this, item);
        }

        TolerationsNestedImpl() {
            this.index = -1;
            this.builder = new TolerationBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.setToTolerations(this.index, this.builder.build());
        }

        @Override
        public N endToleration() {
            return this.and();
        }
    }

    public class SecurityContextNestedImpl<N>
    extends PodSecurityContextFluentImpl<PodSpecFluent.SecurityContextNested<N>>
    implements PodSpecFluent.SecurityContextNested<N>,
    Nested<N> {
        private final PodSecurityContextBuilder builder;

        SecurityContextNestedImpl(PodSecurityContext item) {
            this.builder = new PodSecurityContextBuilder(this, item);
        }

        SecurityContextNestedImpl() {
            this.builder = new PodSecurityContextBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.withSecurityContext(this.builder.build());
        }

        @Override
        public N endSecurityContext() {
            return this.and();
        }
    }

    public class ReadinessGatesNestedImpl<N>
    extends PodReadinessGateFluentImpl<PodSpecFluent.ReadinessGatesNested<N>>
    implements PodSpecFluent.ReadinessGatesNested<N>,
    Nested<N> {
        private final PodReadinessGateBuilder builder;
        private final int index;

        ReadinessGatesNestedImpl(int index, PodReadinessGate item) {
            this.index = index;
            this.builder = new PodReadinessGateBuilder(this, item);
        }

        ReadinessGatesNestedImpl() {
            this.index = -1;
            this.builder = new PodReadinessGateBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.setToReadinessGates(this.index, this.builder.build());
        }

        @Override
        public N endReadinessGate() {
            return this.and();
        }
    }

    public class InitContainersNestedImpl<N>
    extends ContainerFluentImpl<PodSpecFluent.InitContainersNested<N>>
    implements PodSpecFluent.InitContainersNested<N>,
    Nested<N> {
        private final ContainerBuilder builder;
        private final int index;

        InitContainersNestedImpl(int index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder(this, item);
        }

        InitContainersNestedImpl() {
            this.index = -1;
            this.builder = new ContainerBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.setToInitContainers(this.index, this.builder.build());
        }

        @Override
        public N endInitContainer() {
            return this.and();
        }
    }

    public class ImagePullSecretsNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<PodSpecFluent.ImagePullSecretsNested<N>>
    implements PodSpecFluent.ImagePullSecretsNested<N>,
    Nested<N> {
        private final LocalObjectReferenceBuilder builder;
        private final int index;

        ImagePullSecretsNestedImpl(int index, LocalObjectReference item) {
            this.index = index;
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        ImagePullSecretsNestedImpl() {
            this.index = -1;
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.setToImagePullSecrets(this.index, this.builder.build());
        }

        @Override
        public N endImagePullSecret() {
            return this.and();
        }
    }

    public class HostAliasesNestedImpl<N>
    extends HostAliasFluentImpl<PodSpecFluent.HostAliasesNested<N>>
    implements PodSpecFluent.HostAliasesNested<N>,
    Nested<N> {
        private final HostAliasBuilder builder;
        private final int index;

        HostAliasesNestedImpl(int index, HostAlias item) {
            this.index = index;
            this.builder = new HostAliasBuilder(this, item);
        }

        HostAliasesNestedImpl() {
            this.index = -1;
            this.builder = new HostAliasBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.setToHostAliases(this.index, this.builder.build());
        }

        @Override
        public N endHostAlias() {
            return this.and();
        }
    }

    public class DnsConfigNestedImpl<N>
    extends PodDNSConfigFluentImpl<PodSpecFluent.DnsConfigNested<N>>
    implements PodSpecFluent.DnsConfigNested<N>,
    Nested<N> {
        private final PodDNSConfigBuilder builder;

        DnsConfigNestedImpl(PodDNSConfig item) {
            this.builder = new PodDNSConfigBuilder(this, item);
        }

        DnsConfigNestedImpl() {
            this.builder = new PodDNSConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.withDnsConfig(this.builder.build());
        }

        @Override
        public N endDnsConfig() {
            return this.and();
        }
    }

    public class ContainersNestedImpl<N>
    extends ContainerFluentImpl<PodSpecFluent.ContainersNested<N>>
    implements PodSpecFluent.ContainersNested<N>,
    Nested<N> {
        private final ContainerBuilder builder;
        private final int index;

        ContainersNestedImpl(int index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder(this, item);
        }

        ContainersNestedImpl() {
            this.index = -1;
            this.builder = new ContainerBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.setToContainers(this.index, this.builder.build());
        }

        @Override
        public N endContainer() {
            return this.and();
        }
    }

    public class AffinityNestedImpl<N>
    extends AffinityFluentImpl<PodSpecFluent.AffinityNested<N>>
    implements PodSpecFluent.AffinityNested<N>,
    Nested<N> {
        private final AffinityBuilder builder;

        AffinityNestedImpl(Affinity item) {
            this.builder = new AffinityBuilder(this, item);
        }

        AffinityNestedImpl() {
            this.builder = new AffinityBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.withAffinity(this.builder.build());
        }

        @Override
        public N endAffinity() {
            return this.and();
        }
    }
}

