package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

public class DeploymentConfigStatusFluentImpl<A extends DeploymentConfigStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DeploymentConfigStatusFluent<A>{

    private Integer availableReplicas;
    private List<io.fabric8.openshift.api.model.DeploymentConditionBuilder> conditions;
    private DeploymentDetailsBuilder details;
    private Long latestVersion;
    private Long observedGeneration;
    private Integer readyReplicas;
    private Integer replicas;
    private Integer unavailableReplicas;
    private Integer updatedReplicas;

    public DeploymentConfigStatusFluentImpl(){
    }
    public DeploymentConfigStatusFluentImpl(DeploymentConfigStatus instance){
            this.withAvailableReplicas(instance.getAvailableReplicas()); 
            this.withConditions(instance.getConditions()); 
            this.withDetails(instance.getDetails()); 
            this.withLatestVersion(instance.getLatestVersion()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withReadyReplicas(instance.getReadyReplicas()); 
            this.withReplicas(instance.getReplicas()); 
            this.withUnavailableReplicas(instance.getUnavailableReplicas()); 
            this.withUpdatedReplicas(instance.getUpdatedReplicas()); 
    }

    public Integer getAvailableReplicas(){
            return this.availableReplicas;
    }

    public A withAvailableReplicas(Integer availableReplicas){
            this.availableReplicas=availableReplicas; return (A) this;
    }

    public Boolean hasAvailableReplicas(){
            return this.availableReplicas != null;
    }

    public A addToConditions(int index,io.fabric8.openshift.api.model.DeploymentCondition item){
            if (this.conditions == null) {this.conditions = new ArrayList<io.fabric8.openshift.api.model.DeploymentConditionBuilder>();}
            io.fabric8.openshift.api.model.DeploymentConditionBuilder builder = new io.fabric8.openshift.api.model.DeploymentConditionBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,io.fabric8.openshift.api.model.DeploymentCondition item){
            if (this.conditions == null) {this.conditions = new ArrayList<io.fabric8.openshift.api.model.DeploymentConditionBuilder>();}
            io.fabric8.openshift.api.model.DeploymentConditionBuilder builder = new io.fabric8.openshift.api.model.DeploymentConditionBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
             return (A)this;
    }

    public A addToConditions(io.fabric8.openshift.api.model.DeploymentCondition... items){
            if (this.conditions == null) {this.conditions = new ArrayList<io.fabric8.openshift.api.model.DeploymentConditionBuilder>();}
            for (io.fabric8.openshift.api.model.DeploymentCondition item : items) {io.fabric8.openshift.api.model.DeploymentConditionBuilder builder = new io.fabric8.openshift.api.model.DeploymentConditionBuilder(item);_visitables.add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<io.fabric8.openshift.api.model.DeploymentCondition> items){
            if (this.conditions == null) {this.conditions = new ArrayList<io.fabric8.openshift.api.model.DeploymentConditionBuilder>();}
            for (io.fabric8.openshift.api.model.DeploymentCondition item : items) {io.fabric8.openshift.api.model.DeploymentConditionBuilder builder = new io.fabric8.openshift.api.model.DeploymentConditionBuilder(item);_visitables.add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(io.fabric8.openshift.api.model.DeploymentCondition... items){
            for (io.fabric8.openshift.api.model.DeploymentCondition item : items) {io.fabric8.openshift.api.model.DeploymentConditionBuilder builder = new io.fabric8.openshift.api.model.DeploymentConditionBuilder(item);_visitables.remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<io.fabric8.openshift.api.model.DeploymentCondition> items){
            for (io.fabric8.openshift.api.model.DeploymentCondition item : items) {io.fabric8.openshift.api.model.DeploymentConditionBuilder builder = new io.fabric8.openshift.api.model.DeploymentConditionBuilder(item);_visitables.remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<io.fabric8.openshift.api.model.DeploymentCondition> getConditions(){
            return build(conditions);
    }

    public List<io.fabric8.openshift.api.model.DeploymentCondition> buildConditions(){
            return build(conditions);
    }

    public io.fabric8.openshift.api.model.DeploymentCondition buildCondition(int index){
            return this.conditions.get(index).build();
    }

    public io.fabric8.openshift.api.model.DeploymentCondition buildFirstCondition(){
            return this.conditions.get(0).build();
    }

    public io.fabric8.openshift.api.model.DeploymentCondition buildLastCondition(){
            return this.conditions.get(conditions.size() - 1).build();
    }

    public io.fabric8.openshift.api.model.DeploymentCondition buildMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.openshift.api.model.DeploymentConditionBuilder> predicate){
            for (io.fabric8.openshift.api.model.DeploymentConditionBuilder item: conditions) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withConditions(List<io.fabric8.openshift.api.model.DeploymentCondition> conditions){
            if (this.conditions != null) { _visitables.removeAll(this.conditions);}
            if (conditions != null) {this.conditions = new ArrayList<io.fabric8.openshift.api.model.DeploymentConditionBuilder>(); for (io.fabric8.openshift.api.model.DeploymentCondition item : conditions){this.addToConditions(item);}} else { this.conditions = new ArrayList<io.fabric8.openshift.api.model.DeploymentConditionBuilder>();} return (A) this;
    }

    public A withConditions(io.fabric8.openshift.api.model.DeploymentCondition... conditions){
            if (this.conditions != null) {this.conditions.clear();}
            if (conditions != null) {for (io.fabric8.openshift.api.model.DeploymentCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions(){
            return conditions != null && !conditions.isEmpty();
    }

    public DeploymentConfigStatusFluent.ConditionsNested<A> addNewCondition(){
            return new ConditionsNestedImpl();
    }

    public DeploymentConfigStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.openshift.api.model.DeploymentCondition item){
            return new ConditionsNestedImpl(-1, item);
    }

    public DeploymentConfigStatusFluent.ConditionsNested<A> setNewConditionLike(int index,io.fabric8.openshift.api.model.DeploymentCondition item){
            return new ConditionsNestedImpl(index, item);
    }

    public DeploymentConfigStatusFluent.ConditionsNested<A> editCondition(int index){
            if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public DeploymentConfigStatusFluent.ConditionsNested<A> editFirstCondition(){
            if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
            return setNewConditionLike(0, buildCondition(0));
    }

    public DeploymentConfigStatusFluent.ConditionsNested<A> editLastCondition(){
            int index = conditions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public DeploymentConfigStatusFluent.ConditionsNested<A> editMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.openshift.api.model.DeploymentConditionBuilder> predicate){
            int index = -1;
            for (int i=0;i<conditions.size();i++) { 
            if (predicate.apply(conditions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
            return setNewConditionLike(index, buildCondition(index));
    }

    
/**
 * This method has been deprecated, please use method buildDetails instead.
 * @return The buildable object.
 */
@Deprecated public DeploymentDetails getDetails(){
            return this.details!=null?this.details.build():null;
    }

    public DeploymentDetails buildDetails(){
            return this.details!=null?this.details.build():null;
    }

    public A withDetails(DeploymentDetails details){
            _visitables.remove(this.details);
            if (details!=null){ this.details= new DeploymentDetailsBuilder(details); _visitables.add(this.details);} return (A) this;
    }

    public Boolean hasDetails(){
            return this.details != null;
    }

    public DeploymentConfigStatusFluent.DetailsNested<A> withNewDetails(){
            return new DetailsNestedImpl();
    }

    public DeploymentConfigStatusFluent.DetailsNested<A> withNewDetailsLike(DeploymentDetails item){
            return new DetailsNestedImpl(item);
    }

    public DeploymentConfigStatusFluent.DetailsNested<A> editDetails(){
            return withNewDetailsLike(getDetails());
    }

    public DeploymentConfigStatusFluent.DetailsNested<A> editOrNewDetails(){
            return withNewDetailsLike(getDetails() != null ? getDetails(): new DeploymentDetailsBuilder().build());
    }

    public DeploymentConfigStatusFluent.DetailsNested<A> editOrNewDetailsLike(DeploymentDetails item){
            return withNewDetailsLike(getDetails() != null ? getDetails(): item);
    }

    public Long getLatestVersion(){
            return this.latestVersion;
    }

    public A withLatestVersion(Long latestVersion){
            this.latestVersion=latestVersion; return (A) this;
    }

    public Boolean hasLatestVersion(){
            return this.latestVersion != null;
    }

    public A withNewLatestVersion(String arg1){
            return (A)withLatestVersion(new Long(arg1));
    }

    public A withNewLatestVersion(long arg1){
            return (A)withLatestVersion(new Long(arg1));
    }

    public Long getObservedGeneration(){
            return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration){
            this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration(){
            return this.observedGeneration != null;
    }

    public A withNewObservedGeneration(String arg1){
            return (A)withObservedGeneration(new Long(arg1));
    }

    public A withNewObservedGeneration(long arg1){
            return (A)withObservedGeneration(new Long(arg1));
    }

    public Integer getReadyReplicas(){
            return this.readyReplicas;
    }

    public A withReadyReplicas(Integer readyReplicas){
            this.readyReplicas=readyReplicas; return (A) this;
    }

    public Boolean hasReadyReplicas(){
            return this.readyReplicas != null;
    }

    public Integer getReplicas(){
            return this.replicas;
    }

    public A withReplicas(Integer replicas){
            this.replicas=replicas; return (A) this;
    }

    public Boolean hasReplicas(){
            return this.replicas != null;
    }

    public Integer getUnavailableReplicas(){
            return this.unavailableReplicas;
    }

    public A withUnavailableReplicas(Integer unavailableReplicas){
            this.unavailableReplicas=unavailableReplicas; return (A) this;
    }

    public Boolean hasUnavailableReplicas(){
            return this.unavailableReplicas != null;
    }

    public Integer getUpdatedReplicas(){
            return this.updatedReplicas;
    }

    public A withUpdatedReplicas(Integer updatedReplicas){
            this.updatedReplicas=updatedReplicas; return (A) this;
    }

    public Boolean hasUpdatedReplicas(){
            return this.updatedReplicas != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DeploymentConfigStatusFluentImpl that = (DeploymentConfigStatusFluentImpl) o;
            if (availableReplicas != null ? !availableReplicas.equals(that.availableReplicas) :that.availableReplicas != null) return false;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (details != null ? !details.equals(that.details) :that.details != null) return false;
            if (latestVersion != null ? !latestVersion.equals(that.latestVersion) :that.latestVersion != null) return false;
            if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
            if (readyReplicas != null ? !readyReplicas.equals(that.readyReplicas) :that.readyReplicas != null) return false;
            if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
            if (unavailableReplicas != null ? !unavailableReplicas.equals(that.unavailableReplicas) :that.unavailableReplicas != null) return false;
            if (updatedReplicas != null ? !updatedReplicas.equals(that.updatedReplicas) :that.updatedReplicas != null) return false;
            return true;
    }


    public class ConditionsNestedImpl<N> extends io.fabric8.openshift.api.model.DeploymentConditionFluentImpl<DeploymentConfigStatusFluent.ConditionsNested<N>> implements DeploymentConfigStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.openshift.api.model.DeploymentConditionBuilder builder;
        private final int index;
    
            ConditionsNestedImpl(int index,io.fabric8.openshift.api.model.DeploymentCondition item){
                    this.index = index;
                    this.builder = new io.fabric8.openshift.api.model.DeploymentConditionBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.index = -1;
                    this.builder = new io.fabric8.openshift.api.model.DeploymentConditionBuilder(this);
            }
    
    public N and(){
            return (N) DeploymentConfigStatusFluentImpl.this.setToConditions(index, builder.build());
    }
    public N endCondition(){
            return and();
    }

}
    public class DetailsNestedImpl<N> extends DeploymentDetailsFluentImpl<DeploymentConfigStatusFluent.DetailsNested<N>> implements DeploymentConfigStatusFluent.DetailsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DeploymentDetailsBuilder builder;
    
            DetailsNestedImpl(DeploymentDetails item){
                    this.builder = new DeploymentDetailsBuilder(this, item);
            }
            DetailsNestedImpl(){
                    this.builder = new DeploymentDetailsBuilder(this);
            }
    
    public N and(){
            return (N) DeploymentConfigStatusFluentImpl.this.withDetails(builder.build());
    }
    public N endDetails(){
            return and();
    }

}


}
