package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class NodeBuilder extends NodeFluentImpl<NodeBuilder> implements VisitableBuilder<Node,NodeBuilder>{

    NodeFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public NodeBuilder(){
            this(true);
    }
    public NodeBuilder(Boolean validationEnabled){
            this(new Node(), validationEnabled);
    }
    public NodeBuilder(NodeFluent<?> fluent){
            this(fluent, true);
    }
    public NodeBuilder(NodeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Node(), validationEnabled);
    }
    public NodeBuilder(NodeFluent<?> fluent,Node instance){
            this(fluent, instance, true);
    }
    public NodeBuilder(NodeFluent<?> fluent,Node instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public NodeBuilder(Node instance){
            this(instance,true);
    }
    public NodeBuilder(Node instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public NodeBuilder(Validator validator){
            this(new Node(), true);
    }
    public NodeBuilder(NodeFluent<?> fluent,Node instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public NodeBuilder(Node instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Node build(){
            Node buildable = new Node(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NodeBuilder that = (NodeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
