package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class CSIPersistentVolumeSourceFluentImpl<A extends CSIPersistentVolumeSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CSIPersistentVolumeSourceFluent<A>{

    private String driver;
    private Boolean readOnly;
    private String volumeHandle;

    public CSIPersistentVolumeSourceFluentImpl(){
    }
    public CSIPersistentVolumeSourceFluentImpl(CSIPersistentVolumeSource instance){
            this.withDriver(instance.getDriver()); 
            this.withReadOnly(instance.getReadOnly()); 
            this.withVolumeHandle(instance.getVolumeHandle()); 
    }

    public String getDriver(){
            return this.driver;
    }

    public A withDriver(String driver){
            this.driver=driver; return (A) this;
    }

    public Boolean hasDriver(){
            return this.driver != null;
    }

    public Boolean isReadOnly(){
            return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly){
            this.readOnly=readOnly; return (A) this;
    }

    public Boolean hasReadOnly(){
            return this.readOnly != null;
    }

    public A withNewReadOnly(String arg1){
            return (A)withReadOnly(new Boolean(arg1));
    }

    public A withNewReadOnly(boolean arg1){
            return (A)withReadOnly(new Boolean(arg1));
    }

    public String getVolumeHandle(){
            return this.volumeHandle;
    }

    public A withVolumeHandle(String volumeHandle){
            this.volumeHandle=volumeHandle; return (A) this;
    }

    public Boolean hasVolumeHandle(){
            return this.volumeHandle != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CSIPersistentVolumeSourceFluentImpl that = (CSIPersistentVolumeSourceFluentImpl) o;
            if (driver != null ? !driver.equals(that.driver) :that.driver != null) return false;
            if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
            if (volumeHandle != null ? !volumeHandle.equals(that.volumeHandle) :that.volumeHandle != null) return false;
            return true;
    }




}
