package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class PolicyBindingBuilder extends PolicyBindingFluentImpl<PolicyBindingBuilder> implements VisitableBuilder<PolicyBinding,PolicyBindingBuilder>{

    PolicyBindingFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PolicyBindingBuilder(){
            this(true);
    }
    public PolicyBindingBuilder(Boolean validationEnabled){
            this(new PolicyBinding(), validationEnabled);
    }
    public PolicyBindingBuilder(PolicyBindingFluent<?> fluent){
            this(fluent, true);
    }
    public PolicyBindingBuilder(PolicyBindingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PolicyBinding(), validationEnabled);
    }
    public PolicyBindingBuilder(PolicyBindingFluent<?> fluent,PolicyBinding instance){
            this(fluent, instance, true);
    }
    public PolicyBindingBuilder(PolicyBindingFluent<?> fluent,PolicyBinding instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withLastModified(instance.getLastModified()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withPolicyRef(instance.getPolicyRef()); 
            fluent.withRoleBindings(instance.getRoleBindings()); 
            this.validationEnabled = validationEnabled; 
    }
    public PolicyBindingBuilder(PolicyBinding instance){
            this(instance,true);
    }
    public PolicyBindingBuilder(PolicyBinding instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withLastModified(instance.getLastModified()); 
            this.withMetadata(instance.getMetadata()); 
            this.withPolicyRef(instance.getPolicyRef()); 
            this.withRoleBindings(instance.getRoleBindings()); 
            this.validationEnabled = validationEnabled; 
    }
    public PolicyBindingBuilder(Validator validator){
            this(new PolicyBinding(), true);
    }
    public PolicyBindingBuilder(PolicyBindingFluent<?> fluent,PolicyBinding instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withLastModified(instance.getLastModified()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withPolicyRef(instance.getPolicyRef()); 
            fluent.withRoleBindings(instance.getRoleBindings()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public PolicyBindingBuilder(PolicyBinding instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withLastModified(instance.getLastModified()); 
            this.withMetadata(instance.getMetadata()); 
            this.withPolicyRef(instance.getPolicyRef()); 
            this.withRoleBindings(instance.getRoleBindings()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public PolicyBinding build(){
            PolicyBinding buildable = new PolicyBinding(fluent.getApiVersion(),fluent.getKind(),fluent.getLastModified(),fluent.getMetadata(),fluent.getPolicyRef(),fluent.getRoleBindings());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PolicyBindingBuilder that = (PolicyBindingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
